/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.Optional;
import software.amazon.smithy.model.shapes.EntityShape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ServiceShape
extends EntityShape
implements ToSmithyBuilder<ServiceShape> {
    private final String version;

    private ServiceShape(Builder builder) {
        super(builder);
        this.version = (String)SmithyBuilder.requiredState((String)"version", (Object)builder.version);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = ((Builder)ServiceShape.builder().from(this)).version(this.version);
        this.getOperations().forEach(builder::addOperation);
        this.getResources().forEach(builder::addResource);
        return builder;
    }

    @Override
    public <R> R accept(ShapeVisitor<R> cases) {
        return cases.serviceShape(this);
    }

    @Override
    public Optional<ServiceShape> asServiceShape() {
        return Optional.of(this);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        ServiceShape o = (ServiceShape)other;
        return this.version.equals(o.version);
    }

    public String getVersion() {
        return this.version;
    }

    public static final class Builder
    extends EntityShape.Builder<Builder, ServiceShape> {
        private String version;

        public ServiceShape build() {
            return new ServiceShape(this);
        }

        @Override
        public ShapeType getShapeType() {
            return ShapeType.SERVICE;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }
    }
}

