/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.knowledge;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.KnowledgeIndex;
import software.amazon.smithy.model.knowledge.OperationIndex;
import software.amazon.smithy.model.knowledge.PaginationInfo;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.OperationShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.PaginatedTrait;
import software.amazon.smithy.utils.ListUtils;

public final class PaginatedIndex
implements KnowledgeIndex {
    private final Map<ShapeId, Map<ShapeId, PaginationInfo>> paginationInfo = new HashMap<ShapeId, Map<ShapeId, PaginationInfo>>();

    public PaginatedIndex(Model model) {
        TopDownIndex topDownIndex = TopDownIndex.of(model);
        OperationIndex opIndex = OperationIndex.of(model);
        for (ServiceShape service : model.getServiceShapes()) {
            PaginatedTrait serviceTrait = service.getTrait(PaginatedTrait.class).orElse(null);
            HashMap mappings = new HashMap();
            for (OperationShape operation : topDownIndex.getContainedOperations(service)) {
                if (!operation.hasTrait(PaginatedTrait.class)) continue;
                PaginatedTrait merged = operation.expectTrait(PaginatedTrait.class).merge(serviceTrait);
                this.create(model, service, opIndex, operation, merged).ifPresent(info -> mappings.put(info.getOperation().getId(), info));
            }
            this.paginationInfo.put(service.getId(), Collections.unmodifiableMap(mappings));
        }
    }

    public static PaginatedIndex of(Model model) {
        return model.getKnowledge(PaginatedIndex.class, PaginatedIndex::new);
    }

    private Optional<PaginationInfo> create(Model model, ServiceShape service, OperationIndex opIndex, OperationShape operation, PaginatedTrait trait) {
        StructureShape input = opIndex.expectInputShape(operation.getId());
        StructureShape output = opIndex.expectOutputShape(operation.getId());
        MemberShape inputToken = trait.getInputToken().flatMap(x$0 -> input.getMember((String)x$0)).orElse(null);
        List outputTokenPath = trait.getOutputToken().map(path -> PaginatedTrait.resolveFullPath(path, model, output)).orElse(ListUtils.of());
        if (inputToken == null || outputTokenPath.isEmpty()) {
            return Optional.empty();
        }
        MemberShape pageSizeMember = trait.getPageSize().flatMap(x$0 -> input.getMember((String)x$0)).orElse(null);
        List itemsMemberPath = trait.getItems().map(path -> PaginatedTrait.resolveFullPath(path, model, output)).orElse(ListUtils.of());
        return Optional.of(new PaginationInfo(service, operation, input, output, trait, inputToken, outputTokenPath, pageSizeMember, itemsMemberPath));
    }

    public Optional<PaginationInfo> getPaginationInfo(ToShapeId service, ToShapeId operation) {
        return Optional.ofNullable(this.paginationInfo.get(service.toShapeId())).flatMap(mappings -> Optional.ofNullable(mappings.get(operation.toShapeId())));
    }
}

