/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.EnumDefinition;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class EnumTrait
extends AbstractTrait
implements ToSmithyBuilder<EnumTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#enum");
    private final List<EnumDefinition> definitions;

    private EnumTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.definitions = (List)builder.definitions.copy();
        if (this.definitions.isEmpty()) {
            throw new SourceException("enum must have at least one entry", this.getSourceLocation());
        }
    }

    public List<EnumDefinition> getValues() {
        return this.definitions;
    }

    public List<String> getEnumDefinitionValues() {
        return this.definitions.stream().map(EnumDefinition::getValue).collect(Collectors.toList());
    }

    public boolean hasNames() {
        return this.definitions.stream().allMatch(body -> body.getName().isPresent());
    }

    @Override
    protected Node createNode() {
        return this.definitions.stream().map(EnumDefinition::toNode).collect(ArrayNode.collect(this.getSourceLocation()));
    }

    public Builder toBuilder() {
        Builder builder = (Builder)EnumTrait.builder().sourceLocation(this.getSourceLocation());
        this.definitions.forEach(builder::addEnum);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractTraitBuilder<EnumTrait, Builder> {
        private final BuilderRef<List<EnumDefinition>> definitions = BuilderRef.forList();

        public Builder addEnum(EnumDefinition value) {
            ((List)this.definitions.get()).add(value);
            return this;
        }

        public Builder removeEnum(String value) {
            ((List)this.definitions.get()).removeIf(def -> def.getValue().equals(value));
            return this;
        }

        public Builder removeEnumByName(String name) {
            ((List)this.definitions.get()).removeIf(def -> def.getName().filter(n -> n.equals(name)).isPresent());
            return this;
        }

        public Builder clearEnums() {
            this.definitions.clear();
            return this;
        }

        public EnumTrait build() {
            return new EnumTrait(this);
        }
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public EnumTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)EnumTrait.builder().sourceLocation(value);
            for (ObjectNode definition : value.expectArrayNode().getElementsAs(ObjectNode.class)) {
                builder.addEnum(EnumDefinition.fromNode(definition));
            }
            return builder.build();
        }
    }
}

