/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class CorsTrait
extends AbstractTrait
implements ToSmithyBuilder<CorsTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#cors");
    private static final String DEFAULT_ORIGIN = "*";
    private static final int DEFAULT_MAX_AGE = 600;
    private static final String ORIGIN_MEMBER_ID = "origin";
    private static final String MAX_AGE_MEMBER_ID = "maxAge";
    private static final String ALLOWED_HEADERS_MEMBER_ID = "additionalAllowedHeaders";
    private static final String EXPOSED_HEADERS_MEMBER_ID = "additionalExposedHeaders";
    private final String origin;
    private final int maxAge;
    private final Set<String> additionalAllowedHeaders;
    private final Set<String> additionalExposedHeaders;

    private CorsTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.origin = builder.origin;
        this.maxAge = builder.maxAge;
        this.additionalAllowedHeaders = SetUtils.copyOf((Collection)builder.additionalAllowedHeaders);
        this.additionalExposedHeaders = SetUtils.copyOf((Collection)builder.additionalExposedHeaders);
    }

    public String getOrigin() {
        return this.origin;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public Set<String> getAdditionalAllowedHeaders() {
        return this.additionalAllowedHeaders;
    }

    public Set<String> getAdditionalExposedHeaders() {
        return this.additionalExposedHeaders;
    }

    public Builder toBuilder() {
        return ((Builder)CorsTrait.builder().sourceLocation(this.getSourceLocation())).origin(this.origin).maxAge(this.maxAge).additionalAllowedHeaders(this.additionalAllowedHeaders).additionalExposedHeaders(this.additionalExposedHeaders);
    }

    @Override
    protected Node createNode() {
        return new ObjectNode(MapUtils.of(), this.getSourceLocation()).withOptionalMember(ORIGIN_MEMBER_ID, Optional.of(this.origin).filter(val -> !val.equals(DEFAULT_ORIGIN)).map(Node::from)).withOptionalMember(MAX_AGE_MEMBER_ID, Optional.of(this.maxAge).filter(val -> !val.equals(600)).map(Node::from)).withOptionalMember(ALLOWED_HEADERS_MEMBER_ID, Optional.of(this.additionalAllowedHeaders).filter(FunctionalUtils.not(Set::isEmpty)).map(Node::fromStrings)).withOptionalMember(EXPOSED_HEADERS_MEMBER_ID, Optional.of(this.additionalExposedHeaders).filter(FunctionalUtils.not(Set::isEmpty)).map(Node::fromStrings));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractTraitBuilder<CorsTrait, Builder> {
        private String origin = "*";
        private int maxAge = 600;
        private Set<String> additionalAllowedHeaders = SetUtils.of();
        private Set<String> additionalExposedHeaders = SetUtils.of();

        private Builder() {
        }

        public Builder origin(String origin) {
            this.origin = Objects.requireNonNull(origin);
            return this;
        }

        public Builder maxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        public Builder additionalAllowedHeaders(Set<String> additionalAllowedHeaders) {
            this.additionalAllowedHeaders = SetUtils.caseInsensitiveCopyOf(additionalAllowedHeaders);
            return this;
        }

        public Builder additionalExposedHeaders(Set<String> additionalExposedHeaders) {
            this.additionalExposedHeaders = SetUtils.caseInsensitiveCopyOf(additionalExposedHeaders);
            return this;
        }

        public CorsTrait build() {
            return new CorsTrait(this);
        }
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public CorsTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)CorsTrait.builder().sourceLocation(value);
            ObjectNode node = value.expectObjectNode();
            node.getStringMember(CorsTrait.ORIGIN_MEMBER_ID).map(StringNode::getValue).ifPresent(builder::origin);
            node.getNumberMember(CorsTrait.MAX_AGE_MEMBER_ID).map(NumberNode::getValue).map(Number::intValue).ifPresent(builder::maxAge);
            node.getArrayMember(CorsTrait.ALLOWED_HEADERS_MEMBER_ID).map(Provider::stringSetFromNode).ifPresent(builder::additionalAllowedHeaders);
            node.getArrayMember(CorsTrait.EXPOSED_HEADERS_MEMBER_ID).map(Provider::stringSetFromNode).ifPresent(builder::additionalExposedHeaders);
            return builder.build();
        }

        private static Set<String> stringSetFromNode(ArrayNode node) {
            return node.getElements().stream().map(Node::expectStringNode).map(StringNode::getValue).collect(Collectors.toSet());
        }
    }
}

