/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.node;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.node.DefaultNodeDeserializers;
import software.amazon.smithy.model.node.DefaultNodeSerializers;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeDeserializationException;
import software.amazon.smithy.model.node.NodeType;

public final class NodeMapper {
    private static final Logger LOGGER = Logger.getLogger(NodeMapper.class.getName());
    private WhenMissing whenMissing = WhenMissing.WARN;
    private final Set<Type> disableToNode = new HashSet<Type>();
    private final Set<Type> disableFromNode = new HashSet<Type>();
    private boolean serializeNullValues = false;
    private boolean omitEmptyValues;
    private final List<Serializer> serializers = DefaultNodeSerializers.SERIALIZERS;
    private final ObjectCreatorFactory creatorFactory = DefaultNodeDeserializers.DEFAULT_CACHED_CREATOR;

    public void setSerializeNullValues(boolean serializeNullValues) {
        this.serializeNullValues = serializeNullValues;
    }

    public boolean getSerializeNullValues() {
        return this.serializeNullValues;
    }

    public void setWhenMissingSetter(WhenMissing whenMissing) {
        this.whenMissing = Objects.requireNonNull(whenMissing);
    }

    public WhenMissing getWhenMissingSetter() {
        return this.whenMissing;
    }

    public void disableToNodeForClass(Type type) {
        this.disableToNode.add(type);
    }

    public void enableToNodeForClass(Type type) {
        this.disableToNode.remove(type);
    }

    public Set<Type> getDisableToNode() {
        return this.disableToNode;
    }

    public void disableFromNodeForClass(Type type) {
        this.disableFromNode.add(type);
    }

    public void enableFromNodeForClass(Type type) {
        this.disableFromNode.remove(type);
    }

    public Set<Type> getDisableFromNode() {
        return this.disableFromNode;
    }

    public boolean getOmitEmptyValues() {
        return this.omitEmptyValues;
    }

    public void setOmitEmptyValues(boolean omitEmptyValues) {
        this.omitEmptyValues = omitEmptyValues;
    }

    public Node serialize(Object object) {
        return this.serialize(object, Collections.newSetFromMap(new IdentityHashMap()));
    }

    Node serialize(Object object, Set<Object> serializedObject) {
        if (object == null) {
            return Node.nullNode();
        }
        for (Serializer serializer : this.serializers) {
            Node result;
            if (!serializer.getType().isInstance(object) || (result = serializer.serialize(object, serializedObject, this)) == null) continue;
            return result;
        }
        return DefaultNodeSerializers.FROM_BEAN.serialize(object, serializedObject, this);
    }

    public <T> T deserialize(Node value, Class<T> into) {
        return this.deserializeNext(value, "", into, this);
    }

    public <T> T deserializeInto(Node value, T objectToMutate) {
        try {
            DefaultNodeDeserializers.BeanMapper.apply(objectToMutate, value, objectToMutate.getClass(), "", this);
            return objectToMutate;
        }
        catch (ReflectiveOperationException e) {
            throw NodeMapper.createError(objectToMutate.getClass(), "/", value, e.getMessage(), e);
        }
    }

    public <T extends Collection<?>, U, V extends Collection<? extends U>> V deserializeCollection(Node value, final Class<T> into, final Class<U> members) {
        ParameterizedType type = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{members};
            }

            @Override
            public Type getRawType() {
                return into;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
        return (V)((Collection)this.deserializeNext(value, "", type, this));
    }

    public <T extends Map<?, ?>, U, V extends Map<String, ? extends U>> V deserializeMap(Node value, final Class<T> into, final Class<U> members) {
        ParameterizedType type = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{String.class, members};
            }

            @Override
            public Type getRawType() {
                return into;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
        return (V)((Map)this.deserializeNext(value, "", type, this));
    }

    <T> T deserializeNext(Node value, String pointer, Type into, NodeMapper mapper) {
        Objects.requireNonNull(value, "Deserialization value cannot be null");
        Objects.requireNonNull(pointer, "Deserialization pointer cannot be null");
        Objects.requireNonNull(into, "Deserialization into cannot be null");
        Objects.requireNonNull(mapper, "Deserialization mapper cannot be null");
        try {
            ObjectCreator creator = this.creatorFactory.getCreator(value.getType(), into, this);
            if (creator == null) {
                throw NodeMapper.createError(into, pointer, value, null, null);
            }
            return (T)creator.create(value, into, pointer, mapper);
        }
        catch (NodeDeserializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw NodeMapper.createError(into, pointer, value, e.getMessage(), e);
        }
    }

    private static NodeDeserializationException createError(Type into, String pointer, Node node, String message, Throwable cause) {
        String errorMessage = NodeMapper.createErrorMessage(into, pointer, node, message);
        return new NodeDeserializationException(errorMessage, node.getSourceLocation(), cause);
    }

    static String createErrorMessage(Type into, String pointer, Node node, String message) {
        String formatted = String.format("Deserialization error at %s: unable to create %s from %s", NodeMapper.getNormalizedPointer(pointer), into.getTypeName(), Node.printJson(node));
        if (message != null) {
            formatted = formatted + ": " + message;
        }
        return formatted;
    }

    private static String getNormalizedPointer(String pointer) {
        return "(" + (pointer.equals(" ") || pointer.isEmpty() ? "/" : pointer) + ")";
    }

    public static enum WhenMissing {
        FAIL{

            @Override
            public void handle(Type into, String pointer, String property, Node value) {
                String message = WhenMissing.createMessage(property, pointer, into, value);
                throw new NodeDeserializationException(message, value.getSourceLocation());
            }
        }
        ,
        WARN{

            @Override
            public void handle(Type into, String pointer, String property, Node value) {
                LOGGER.warning(WhenMissing.createMessage(property, pointer, into, value));
            }
        }
        ,
        INGORE{

            @Override
            public void handle(Type into, String pointer, String property, Node value) {
            }
        };


        public abstract void handle(Type var1, String var2, String var3, Node var4);

        private static String createMessage(String property, String pointer, Type into, Node node) {
            String location = node.getSourceLocation() == SourceLocation.NONE ? "" : " " + node.getSourceLocation().toString().trim();
            return String.format("Deserialization error at %s%s: unable to find setter method for `%s` on %s", NodeMapper.getNormalizedPointer(pointer), location, property, into.getTypeName());
        }
    }

    @FunctionalInterface
    static interface ObjectCreatorFactory {
        public ObjectCreator getCreator(NodeType var1, Type var2, NodeMapper var3);
    }

    static interface Serializer<T> {
        public Class<T> getType();

        public Node serialize(T var1, Set<Object> var2, NodeMapper var3);
    }

    @FunctionalInterface
    static interface ObjectCreator {
        public Object create(Node var1, Type var2, String var3, NodeMapper var4);
    }

    static interface ObjectClassCreatorFactory {
        public ObjectCreator getCreator(NodeType var1, Class<?> var2, NodeMapper var3);
    }
}

