/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform;

import java.util.Map;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.transform.ModelTransformer;

final class ChangeShapeType {
    private final Map<ShapeId, ShapeType> shapeToType;

    ChangeShapeType(Map<ShapeId, ShapeType> shapeToType) {
        this.shapeToType = shapeToType;
    }

    Model transform(ModelTransformer transformer, Model model) {
        return transformer.mapShapes(model, shape -> {
            if (this.shapeToType.containsKey(shape.getId())) {
                return shape.accept(new Retype(this.shapeToType.get(shape.getId())));
            }
            return shape;
        });
    }

    private static final class Retype
    extends ShapeVisitor.Default<Shape> {
        private final ShapeType to;

        Retype(ShapeType to) {
            this.to = to;
        }

        @Override
        protected Shape getDefault(Shape shape) {
            throw this.invalidType(shape, this.to, (Object)((Object)shape.getType()) + " cannot be retyped.");
        }

        @Override
        public Shape blobShape(BlobShape shape) {
            return this.copyToSimpleShape(this.to, shape);
        }

        @Override
        public Shape booleanShape(BooleanShape shape) {
            return this.copyToSimpleShape(this.to, shape);
        }

        @Override
        public Shape byteShape(ByteShape shape) {
            return this.copyToSimpleShape(this.to, shape);
        }

        @Override
        public Shape shortShape(ShortShape shape) {
            return this.copyToSimpleShape(this.to, shape);
        }

        @Override
        public Shape integerShape(IntegerShape shape) {
            return this.copyToSimpleShape(this.to, shape);
        }

        @Override
        public Shape longShape(LongShape shape) {
            return this.copyToSimpleShape(this.to, shape);
        }

        @Override
        public Shape floatShape(FloatShape shape) {
            return this.copyToSimpleShape(this.to, shape);
        }

        @Override
        public Shape doubleShape(DoubleShape shape) {
            return this.copyToSimpleShape(this.to, shape);
        }

        @Override
        public Shape documentShape(DocumentShape shape) {
            return this.copyToSimpleShape(this.to, shape);
        }

        @Override
        public Shape bigIntegerShape(BigIntegerShape shape) {
            return this.copyToSimpleShape(this.to, shape);
        }

        @Override
        public Shape bigDecimalShape(BigDecimalShape shape) {
            return this.copyToSimpleShape(this.to, shape);
        }

        @Override
        public Shape stringShape(StringShape shape) {
            return this.copyToSimpleShape(this.to, shape);
        }

        @Override
        public Shape timestampShape(TimestampShape shape) {
            return this.copyToSimpleShape(this.to, shape);
        }

        @Override
        public Shape listShape(ListShape shape) {
            if (this.to != ShapeType.SET) {
                throw this.invalidType(shape, this.to, "Lists can only be converted to sets.");
            }
            SetShape.Builder builder = SetShape.builder();
            this.copySharedPartsToShape(shape, builder);
            return builder.build();
        }

        @Override
        public Shape setShape(SetShape shape) {
            if (this.to != ShapeType.LIST) {
                throw this.invalidType(shape, this.to, "Sets can only be converted to lists.");
            }
            ListShape.Builder builder = ListShape.builder();
            this.copySharedPartsToShape(shape, builder);
            return builder.build();
        }

        @Override
        public Shape structureShape(StructureShape shape) {
            if (this.to != ShapeType.UNION) {
                throw this.invalidType(shape, this.to, "Structures can only be converted to unions.");
            }
            UnionShape.Builder builder = UnionShape.builder();
            this.copySharedPartsToShape(shape, builder);
            return builder.build();
        }

        @Override
        public Shape unionShape(UnionShape shape) {
            if (this.to != ShapeType.STRUCTURE) {
                throw this.invalidType(shape, this.to, "Unions can only be converted to structures.");
            }
            StructureShape.Builder builder = StructureShape.builder();
            this.copySharedPartsToShape(shape, builder);
            return builder.build();
        }

        private void copySharedPartsToShape(Shape source, AbstractShapeBuilder<?, ?> builder) {
            builder.traits(source.getAllTraits().values());
            builder.id(source.getId());
            builder.source(source.getSourceLocation());
            for (MemberShape member : source.members()) {
                builder.addMember(member);
            }
        }

        private Shape copyToSimpleShape(ShapeType to, Shape shape) {
            if (to.getCategory() != ShapeType.Category.SIMPLE) {
                throw this.invalidType(shape, to, "Simple types can only be converted to other simple types.");
            }
            AbstractShapeBuilder<?, ?> shapeBuilder = to.createBuilderForType();
            this.copySharedPartsToShape(shape, shapeBuilder);
            return (Shape)shapeBuilder.build();
        }

        private IllegalArgumentException invalidType(Shape shape, ShapeType to, String message) {
            return new IllegalArgumentException("Cannot convert " + shape + " to " + (Object)((Object)to) + ". " + message);
        }
    }
}

