/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public final class TraitTargetValidator
extends AbstractValidator {
    private static final Pattern SANITIZE = Pattern.compile("\n\\s*");

    @Override
    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        HashMap selectorCache = new HashMap();
        for (ShapeId traitId : model.getAppliedTraits()) {
            model.getTraitDefinition(traitId).ifPresent(definition -> {
                Set<Shape> shapes = model.getShapesWithTrait(traitId);
                this.validateTraitTargets(model, events, traitId, definition.getSelector(), shapes, selectorCache);
            });
        }
        selectorCache.clear();
        return events;
    }

    private void validateTraitTargets(Model model, List<ValidationEvent> events, ShapeId trait, Selector selector, Set<Shape> appliedTo, Map<Selector, Set<Shape>> selectorCache) {
        if (selector.toString().equals("*")) {
            return;
        }
        Set matches = selectorCache.computeIfAbsent(selector, s -> s.select(model));
        for (Shape shape : appliedTo) {
            if (matches.contains(shape)) continue;
            String sanitized = SANITIZE.matcher(selector.toString()).replaceAll(" ");
            events.add(this.error(shape, shape.findTrait(trait).get(), String.format("Trait `%s` cannot be applied to `%s`. This trait may only be applied to shapes that match the following selector: %s", Trait.getIdiomaticTraitName(trait.toShapeId()), shape.getId(), sanitized)));
        }
    }
}

