/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Objects;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NumberNode;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.pattern.UriPattern;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class HttpTrait
extends AbstractTrait
implements ToSmithyBuilder<HttpTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#http");
    private final String method;
    private final UriPattern uri;
    private final int code;

    private HttpTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.method = Objects.requireNonNull(builder.method, "method not set");
        this.uri = Objects.requireNonNull(builder.uri, "uri not set");
        this.code = builder.code;
    }

    public UriPattern getUri() {
        return this.uri;
    }

    public String getMethod() {
        return this.method;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    protected Node createNode() {
        return new ObjectNode(MapUtils.of(), this.getSourceLocation()).withMember("method", Node.from(this.method)).withMember("uri", Node.from(this.uri.toString())).withMember("code", Node.from(this.code));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ((Builder)new Builder().sourceLocation(this.getSourceLocation())).method(this.method).uri(this.uri).code(this.code);
    }

    public static final class Builder
    extends AbstractTraitBuilder<HttpTrait, Builder> {
        private String method;
        private UriPattern uri;
        private int code = 200;

        public Builder uri(UriPattern uri) {
            this.uri = uri;
            return this;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder code(int code) {
            this.code = code;
            return this;
        }

        public HttpTrait build() {
            return new HttpTrait(this);
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)HttpTrait.builder().sourceLocation(value);
            ObjectNode members = value.expectObjectNode();
            builder.uri(UriPattern.parse(members.expectStringMember("uri").getValue()));
            builder.method(members.expectStringMember("method").getValue());
            builder.code(members.getNumberMember("code").map(NumberNode::getValue).map(Number::intValue).orElse(200));
            return builder.build();
        }
    }
}

