/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.List;
import software.amazon.smithy.model.selector.AndSelector;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.selector.ShapeTypeSelector;
import software.amazon.smithy.model.shapes.Shape;

final class WrappedSelector
implements Selector {
    private final String expression;
    private final InternalSelector delegate;
    private final Class<? extends Shape> startingShapeType;

    WrappedSelector(String expression, List<InternalSelector> selectors) {
        this.expression = expression;
        if (selectors.get(0) instanceof ShapeTypeSelector) {
            this.startingShapeType = ((ShapeTypeSelector)selectors.get((int)0)).shapeType.getShapeClass();
            this.delegate = AndSelector.of(selectors.subList(1, selectors.size()));
        } else {
            this.startingShapeType = null;
            this.delegate = AndSelector.of(selectors);
        }
    }

    @Override
    public Selector.Runner runner() {
        return new Selector.Runner(this.delegate, this.startingShapeType);
    }

    public String toString() {
        return this.expression;
    }

    public boolean equals(Object other) {
        return other instanceof WrappedSelector && this.expression.equals(((WrappedSelector)other).expression);
    }

    public int hashCode() {
        return this.expression.hashCode();
    }
}

