/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.selector.AndSelector;
import software.amazon.smithy.model.selector.AttributeComparator;
import software.amazon.smithy.model.selector.AttributeSelector;
import software.amazon.smithy.model.selector.AttributeValue;
import software.amazon.smithy.model.selector.ForwardNeighborSelector;
import software.amazon.smithy.model.selector.InternalSelector;
import software.amazon.smithy.model.selector.IsSelector;
import software.amazon.smithy.model.selector.NotSelector;
import software.amazon.smithy.model.selector.RecursiveNeighborSelector;
import software.amazon.smithy.model.selector.ReverseNeighborSelector;
import software.amazon.smithy.model.selector.ScopedAttributeSelector;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.selector.SelectorSyntaxException;
import software.amazon.smithy.model.selector.ShapeTypeCategorySelector;
import software.amazon.smithy.model.selector.ShapeTypeSelector;
import software.amazon.smithy.model.selector.TestSelector;
import software.amazon.smithy.model.selector.VariableGetSelector;
import software.amazon.smithy.model.selector.VariableStoreSelector;
import software.amazon.smithy.model.selector.WrappedSelector;
import software.amazon.smithy.model.shapes.CollectionShape;
import software.amazon.smithy.model.shapes.NumberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.SimpleShape;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SetUtils;

final class Parser {
    private static final Logger LOGGER = Logger.getLogger(Parser.class.getName());
    private static final Set<Character> BREAK_TOKENS = SetUtils.of((Object[])new Character[]{Character.valueOf(','), Character.valueOf(']'), Character.valueOf(')')});
    private static final Set<String> REL_TYPES = new HashSet<String>();
    private final String expression;
    private final int length;
    private int position = 0;

    private Parser(String selector) {
        this.expression = selector;
        this.length = this.expression.length();
    }

    static Selector parse(String selector) {
        return new WrappedSelector(selector, new Parser(selector).expression());
    }

    private List<InternalSelector> expression() {
        return this.recursiveParse();
    }

    private List<InternalSelector> recursiveParse() {
        ArrayList<InternalSelector> selectors = new ArrayList<InternalSelector>();
        selectors.add(this.createSelector());
        this.ws();
        while (this.position != this.length && !BREAK_TOKENS.contains(Character.valueOf(this.expression.charAt(this.position)))) {
            selectors.add(this.createSelector());
            this.ws();
        }
        return selectors;
    }

    private InternalSelector createSelector() {
        this.ws();
        switch (this.charPeek()) {
            case ':': {
                ++this.position;
                return this.parseSelectorFunction();
            }
            case '[': {
                ++this.position;
                if (this.charPeek() == '@') {
                    ++this.position;
                    return this.parseScopedAttribute();
                }
                return this.parseAttribute();
            }
            case '>': {
                ++this.position;
                return new ForwardNeighborSelector(ListUtils.of());
            }
            case '<': {
                ++this.position;
                if (this.charPeek() == '-') {
                    ++this.position;
                    this.expect('[');
                    return this.parseSelectorDirectedReverseNeighbor();
                }
                return new ReverseNeighborSelector(ListUtils.of());
            }
            case '~': {
                ++this.position;
                this.expect('>');
                return new RecursiveNeighborSelector();
            }
            case '-': {
                ++this.position;
                this.expect('[');
                return this.parseSelectorForwardDirectedNeighbor();
            }
            case '*': {
                ++this.position;
                return InternalSelector.IDENTITY;
            }
            case '$': {
                ++this.position;
                return this.parseVariable();
            }
        }
        if (this.validIdentifierStart(this.charPeek())) {
            String identifier;
            switch (identifier = this.parseIdentifier()) {
                case "number": {
                    return new ShapeTypeCategorySelector(NumberShape.class);
                }
                case "simpleType": {
                    return new ShapeTypeCategorySelector(SimpleShape.class);
                }
                case "collection": {
                    return new ShapeTypeCategorySelector(CollectionShape.class);
                }
            }
            ShapeType shape = ShapeType.fromString(identifier).orElseThrow(() -> this.syntax("Unknown shape type: " + identifier));
            return new ShapeTypeSelector(shape);
        }
        char c = this.charPeek();
        if (c == '\u0000') {
            throw this.syntax("Unexpected selector EOF");
        }
        throw this.syntax("Unexpected selector character: " + this.charPeek());
    }

    private void ws() {
        char c;
        while (this.position < this.length && ((c = this.expression.charAt(this.position)) == ' ' || c == '\t' || c == '\r' || c == '\n')) {
            ++this.position;
        }
    }

    private char charPeek() {
        return this.position == this.length ? (char)'\u0000' : this.expression.charAt(this.position);
    }

    private char expect(char token) {
        if (this.charPeek() == token) {
            ++this.position;
            return token;
        }
        throw this.syntax("Expected: '" + token + "'");
    }

    private char expect(char ... tokens) {
        for (char token : tokens) {
            if (this.charPeek() != token) continue;
            ++this.position;
            return token;
        }
        StringBuilder message = new StringBuilder("Expected one of the following tokens:");
        for (char c : tokens) {
            message.append(' ').append('\'').append(c).append('\'');
        }
        throw this.syntax(message.toString());
    }

    private SelectorSyntaxException syntax(String message) {
        return new SelectorSyntaxException(message, this.expression, this.position);
    }

    private InternalSelector parseVariable() {
        this.ws();
        if (this.charPeek() == '{') {
            ++this.position;
            this.ws();
            String variableName = this.parseIdentifier();
            this.ws();
            this.expect('}');
            return new VariableGetSelector(variableName);
        }
        String name = this.parseIdentifier();
        this.ws();
        this.expect('(');
        this.ws();
        InternalSelector selector = AndSelector.of(this.recursiveParse());
        this.ws();
        this.expect(')');
        return new VariableStoreSelector(name, selector);
    }

    private InternalSelector parseSelectorForwardDirectedNeighbor() {
        List<String> relationships = this.parseSelectorDirectedRelationships();
        this.expect('-');
        this.expect('>');
        return new ForwardNeighborSelector(relationships);
    }

    private InternalSelector parseSelectorDirectedReverseNeighbor() {
        List<String> relationships = this.parseSelectorDirectedRelationships();
        this.expect('-');
        return new ReverseNeighborSelector(relationships);
    }

    private List<String> parseSelectorDirectedRelationships() {
        char peek;
        ArrayList<String> relationships = new ArrayList<String>();
        do {
            this.ws();
            String next = this.parseIdentifier();
            relationships.add(next);
            if (!REL_TYPES.contains(next)) {
                LOGGER.warning(String.format("Unknown relationship type '%s' found near %s. Expected one of: %s", next, this.position - next.length(), REL_TYPES));
            }
            this.ws();
        } while ((peek = this.expect(']', ',')) != ']');
        return relationships;
    }

    private InternalSelector parseSelectorFunction() {
        int functionPosition = this.position;
        String name = this.parseIdentifier();
        List<InternalSelector> selectors = this.parseSelectorFunctionArgs();
        switch (name) {
            case "not": {
                if (selectors.size() != 1) {
                    throw new SelectorSyntaxException("The :not function requires a single selector argument", this.expression, functionPosition);
                }
                return new NotSelector(selectors.get(0));
            }
            case "test": {
                return new TestSelector(selectors);
            }
            case "is": {
                return IsSelector.of(selectors);
            }
            case "each": {
                LOGGER.warning("The `:each` selector function has been renamed to `:is`: " + this.expression);
                return IsSelector.of(selectors);
            }
        }
        LOGGER.warning(String.format("Unknown function name `%s` found in selector: %s", name, this.expression));
        return (context, shape, next) -> true;
    }

    private List<InternalSelector> parseSelectorFunctionArgs() {
        char next;
        this.ws();
        ArrayList<InternalSelector> selectors = new ArrayList<InternalSelector>();
        this.expect('(');
        do {
            selectors.add(AndSelector.of(this.recursiveParse()));
            this.ws();
        } while ((next = this.expect(')', ',')) != ')');
        return selectors;
    }

    private InternalSelector parseAttribute() {
        this.ws();
        BiFunction<Shape, Map<String, Set<Shape>>, AttributeValue> keyFactory = this.parseAttributePath();
        this.ws();
        char next = this.expect(']', '=', '!', '^', '$', '*', '?', '>', '<');
        if (next == ']') {
            return AttributeSelector.existence(keyFactory);
        }
        AttributeComparator comparator = this.parseComparator(next);
        List<String> values = this.parseAttributeValues();
        boolean insensitive = this.parseCaseInsensitiveToken();
        this.expect(']');
        return new AttributeSelector(keyFactory, values, comparator, insensitive);
    }

    private boolean parseCaseInsensitiveToken() {
        boolean insensitive;
        this.ws();
        boolean bl = insensitive = this.charPeek() == 'i';
        if (insensitive) {
            ++this.position;
            this.ws();
        }
        return insensitive;
    }

    private AttributeComparator parseComparator(char next) {
        AttributeComparator comparator;
        switch (next) {
            case '=': {
                comparator = AttributeComparator.EQUALS;
                break;
            }
            case '!': {
                this.expect('=');
                comparator = AttributeComparator.NOT_EQUALS;
                break;
            }
            case '^': {
                this.expect('=');
                comparator = AttributeComparator.STARTS_WITH;
                break;
            }
            case '$': {
                this.expect('=');
                comparator = AttributeComparator.ENDS_WITH;
                break;
            }
            case '*': {
                this.expect('=');
                comparator = AttributeComparator.CONTAINS;
                break;
            }
            case '?': {
                this.expect('=');
                comparator = AttributeComparator.EXISTS;
                break;
            }
            case '>': {
                if (this.charPeek() == '=') {
                    ++this.position;
                    comparator = AttributeComparator.GTE;
                    break;
                }
                comparator = AttributeComparator.GT;
                break;
            }
            case '<': {
                if (this.charPeek() == '=') {
                    ++this.position;
                    comparator = AttributeComparator.LTE;
                    break;
                }
                comparator = AttributeComparator.LT;
                break;
            }
            case '{': {
                char nextSet = this.expect('<', '=', '!');
                if (nextSet == '<') {
                    if (this.charPeek() == '<') {
                        this.expect('<');
                        comparator = AttributeComparator.PROPER_SUBSET;
                    } else {
                        comparator = AttributeComparator.SUBSET;
                    }
                } else if (nextSet == '=') {
                    comparator = AttributeComparator.PROJECTION_EQUALS;
                } else {
                    this.expect('=');
                    comparator = AttributeComparator.PROJECTION_NOT_EQUALS;
                }
                this.expect('}');
                break;
            }
            default: {
                throw this.syntax("Unknown attribute comparator token '" + next + "'");
            }
        }
        this.ws();
        return comparator;
    }

    private InternalSelector parseScopedAttribute() {
        this.ws();
        BiFunction<Shape, Map<String, Set<Shape>>, AttributeValue> keyScope = this.parseAttributePath();
        this.ws();
        this.expect(':');
        this.ws();
        return new ScopedAttributeSelector(keyScope, this.parseScopedAssertions());
    }

    private List<ScopedAttributeSelector.Assertion> parseScopedAssertions() {
        ArrayList<ScopedAttributeSelector.Assertion> assertions = new ArrayList<ScopedAttributeSelector.Assertion>();
        assertions.add(this.parseScopedAssertion());
        this.ws();
        while (this.charPeek() == '&') {
            this.expect('&');
            this.expect('&');
            this.ws();
            assertions.add(this.parseScopedAssertion());
        }
        this.expect(']');
        return assertions;
    }

    private ScopedAttributeSelector.Assertion parseScopedAssertion() {
        ScopedAttributeSelector.ScopedFactory lhs = this.parseScopedValue();
        char next = this.charPeek();
        ++this.position;
        AttributeComparator comparator = this.parseComparator(next);
        ArrayList<ScopedAttributeSelector.ScopedFactory> rhs = new ArrayList<ScopedAttributeSelector.ScopedFactory>();
        rhs.add(this.parseScopedValue());
        while (this.charPeek() == ',') {
            ++this.position;
            rhs.add(this.parseScopedValue());
        }
        boolean insensitive = this.parseCaseInsensitiveToken();
        return new ScopedAttributeSelector.Assertion(lhs, comparator, rhs, insensitive);
    }

    private ScopedAttributeSelector.ScopedFactory parseScopedValue() {
        this.ws();
        if (this.charPeek() == '@') {
            ++this.position;
            this.expect('{');
            ArrayList<String> path = new ArrayList<String>();
            path.add(this.parseSelectorPathSegment());
            path.addAll(this.parseSelectorPath());
            this.expect('}');
            this.ws();
            return value -> value.getPath(path);
        }
        String parsedValue = this.parseAttributeValue();
        this.ws();
        return value -> AttributeValue.literal(parsedValue);
    }

    private BiFunction<Shape, Map<String, Set<Shape>>, AttributeValue> parseAttributePath() {
        this.ws();
        if (this.charPeek() == ':') {
            return AttributeValue::shape;
        }
        ArrayList<String> path = new ArrayList<String>();
        path.add(this.parseIdentifier());
        path.addAll(this.parseSelectorPath());
        return (shape, variables) -> AttributeValue.shape(shape, variables).getPath(path);
    }

    private List<String> parseSelectorPath() {
        this.ws();
        if (this.charPeek() != '|') {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        do {
            ++this.position;
            result.add(this.parseSelectorPathSegment());
        } while (this.charPeek() == '|');
        return result;
    }

    private String parseSelectorPathSegment() {
        this.ws();
        if (this.charPeek() == '(') {
            ++this.position;
            String propertyName = this.parseIdentifier();
            this.expect(')');
            return "(" + propertyName + ")";
        }
        return this.parseAttributeValue();
    }

    private List<String> parseAttributeValues() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.parseAttributeValue());
        this.ws();
        while (this.charPeek() == ',') {
            ++this.position;
            result.add(this.parseAttributeValue());
            this.ws();
        }
        return result;
    }

    private String parseAttributeValue() {
        this.ws();
        switch (this.charPeek()) {
            case '\'': {
                return this.consumeInside('\'');
            }
            case '\"': {
                return this.consumeInside('\"');
            }
            case '-': {
                ++this.position;
                return this.parseNumber(true);
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return this.parseNumber(false);
            }
        }
        return this.parseShapeId();
    }

    private String consumeInside(char c) {
        for (int i = ++this.position; i < this.length; ++i) {
            if (this.expression.charAt(i) != c) continue;
            String result = this.expression.substring(this.position, i);
            this.position = i + 1;
            this.ws();
            return result;
        }
        throw this.syntax("Expected " + c + " to close " + this.expression.substring(this.position));
    }

    private String parseIdentifier() {
        StringBuilder builder = new StringBuilder();
        char current = this.charPeek();
        if (!this.validIdentifierStart(current)) {
            throw this.syntax("Invalid attribute start character `" + current + "`");
        }
        builder.append(current);
        ++this.position;
        current = this.charPeek();
        while (this.validIdentifierInner(current)) {
            builder.append(current);
            ++this.position;
            current = this.charPeek();
        }
        return builder.toString();
    }

    private boolean validIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private boolean validIdentifierInner(char c) {
        return this.validIdentifierStart(c) || c >= '0' && c <= '9';
    }

    private String parseShapeId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.parseIdentifier());
        if (this.charPeek() == '.') {
            do {
                ++this.position;
                builder.append('.').append(this.parseIdentifier());
            } while (this.charPeek() == '.');
            this.expect('#');
            builder.append('#').append(this.parseIdentifier());
        } else if (this.charPeek() == '#') {
            ++this.position;
            builder.append('#').append(this.parseIdentifier());
        }
        return builder.toString();
    }

    private String parseNumber(boolean negative) {
        StringBuilder result = new StringBuilder();
        if (negative) {
            result.append('-');
        }
        this.addSimpleNumberToBuilder(result);
        if (this.charPeek() == '.') {
            result.append('.');
            ++this.position;
            this.addSimpleNumberToBuilder(result);
        }
        if (this.charPeek() == 'e') {
            result.append('e');
            ++this.position;
            if (this.charPeek() == '-' || this.charPeek() == '+') {
                result.append(this.charPeek());
                ++this.position;
            }
            this.addSimpleNumberToBuilder(result);
        }
        return result.toString();
    }

    private void addSimpleNumberToBuilder(StringBuilder result) {
        result.append(this.expect('0', '1', '2', '3', '4', '5', '6', '7', '8', '9'));
        while (Character.isDigit(this.charPeek())) {
            result.append(this.charPeek());
            ++this.position;
        }
    }

    static {
        for (RelationshipType rel : RelationshipType.values()) {
            rel.getSelectorLabel().ifPresent(REL_TYPES::add);
        }
    }
}

