/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.IdlModelLoader;
import software.amazon.smithy.model.loader.LoaderVisitor;
import software.amazon.smithy.model.loader.ModelAssembler;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.AuthDefinitionTrait;
import software.amazon.smithy.model.traits.AuthTrait;
import software.amazon.smithy.model.traits.BoxTrait;
import software.amazon.smithy.model.traits.CorsTrait;
import software.amazon.smithy.model.traits.DeprecatedTrait;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.EndpointTrait;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.traits.ErrorTrait;
import software.amazon.smithy.model.traits.EventHeaderTrait;
import software.amazon.smithy.model.traits.EventPayloadTrait;
import software.amazon.smithy.model.traits.ExamplesTrait;
import software.amazon.smithy.model.traits.ExternalDocumentationTrait;
import software.amazon.smithy.model.traits.HostLabelTrait;
import software.amazon.smithy.model.traits.HttpApiKeyAuthTrait;
import software.amazon.smithy.model.traits.HttpBasicAuthTrait;
import software.amazon.smithy.model.traits.HttpBearerAuthTrait;
import software.amazon.smithy.model.traits.HttpDigestAuthTrait;
import software.amazon.smithy.model.traits.HttpErrorTrait;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpLabelTrait;
import software.amazon.smithy.model.traits.HttpPayloadTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.HttpQueryTrait;
import software.amazon.smithy.model.traits.HttpTrait;
import software.amazon.smithy.model.traits.IdRefTrait;
import software.amazon.smithy.model.traits.IdempotencyTokenTrait;
import software.amazon.smithy.model.traits.IdempotentTrait;
import software.amazon.smithy.model.traits.JsonNameTrait;
import software.amazon.smithy.model.traits.LengthTrait;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.NoReplaceTrait;
import software.amazon.smithy.model.traits.OptionalAuthTrait;
import software.amazon.smithy.model.traits.PaginatedTrait;
import software.amazon.smithy.model.traits.PatternTrait;
import software.amazon.smithy.model.traits.PrivateTrait;
import software.amazon.smithy.model.traits.ProtocolDefinitionTrait;
import software.amazon.smithy.model.traits.RangeTrait;
import software.amazon.smithy.model.traits.ReadonlyTrait;
import software.amazon.smithy.model.traits.ReferencesTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.traits.RequiresLengthTrait;
import software.amazon.smithy.model.traits.ResourceIdentifierTrait;
import software.amazon.smithy.model.traits.RetryableTrait;
import software.amazon.smithy.model.traits.SensitiveTrait;
import software.amazon.smithy.model.traits.SinceTrait;
import software.amazon.smithy.model.traits.StreamingTrait;
import software.amazon.smithy.model.traits.SuppressTrait;
import software.amazon.smithy.model.traits.TagsTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;
import software.amazon.smithy.model.traits.TitleTrait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.traits.UniqueItemsTrait;
import software.amazon.smithy.model.traits.UnstableTrait;
import software.amazon.smithy.model.traits.XmlAttributeTrait;
import software.amazon.smithy.model.traits.XmlFlattenedTrait;
import software.amazon.smithy.model.traits.XmlNameTrait;
import software.amazon.smithy.model.traits.XmlNamespaceTrait;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SetUtils;

public final class Prelude {
    public static final String NAMESPACE = "smithy.api";
    private static final List<AbstractShapeBuilder> PUBLIC_PRELUDE_SHAPES = ListUtils.of((Object[])new AbstractShapeBuilder[]{StringShape.builder().id("smithy.api#String"), BlobShape.builder().id("smithy.api#Blob"), BigIntegerShape.builder().id("smithy.api#BigInteger"), BigDecimalShape.builder().id("smithy.api#BigDecimal"), TimestampShape.builder().id("smithy.api#Timestamp"), DocumentShape.builder().id("smithy.api#Document"), ((BooleanShape.Builder)BooleanShape.builder().id("smithy.api#Boolean")).addTrait(new BoxTrait()), BooleanShape.builder().id("smithy.api#PrimitiveBoolean"), ((ByteShape.Builder)ByteShape.builder().id("smithy.api#Byte")).addTrait(new BoxTrait()), ByteShape.builder().id("smithy.api#PrimitiveByte"), ((ShortShape.Builder)ShortShape.builder().id("smithy.api#Short")).addTrait(new BoxTrait()), ShortShape.builder().id("smithy.api#PrimitiveShort"), ((IntegerShape.Builder)IntegerShape.builder().id("smithy.api#Integer")).addTrait(new BoxTrait()), IntegerShape.builder().id("smithy.api#PrimitiveInteger"), ((LongShape.Builder)LongShape.builder().id("smithy.api#Long")).addTrait(new BoxTrait()), LongShape.builder().id("smithy.api#PrimitiveLong"), ((FloatShape.Builder)FloatShape.builder().id("smithy.api#Float")).addTrait(new BoxTrait()), FloatShape.builder().id("smithy.api#PrimitiveFloat"), ((DoubleShape.Builder)DoubleShape.builder().id("smithy.api#Double")).addTrait(new BoxTrait()), DoubleShape.builder().id("smithy.api#PrimitiveDouble")});
    private static final Set<ShapeId> PRELUDE_TRAITS = SetUtils.of((Object[])new ShapeId[]{AuthTrait.ID, BoxTrait.ID, CorsTrait.ID, DeprecatedTrait.ID, DocumentationTrait.ID, EndpointTrait.ID, EnumTrait.ID, ErrorTrait.ID, EventHeaderTrait.ID, EventPayloadTrait.ID, ExamplesTrait.ID, ExternalDocumentationTrait.ID, HostLabelTrait.ID, HttpErrorTrait.ID, HttpHeaderTrait.ID, HttpLabelTrait.ID, HttpPayloadTrait.ID, HttpPrefixHeadersTrait.ID, HttpQueryTrait.ID, HttpTrait.ID, IdRefTrait.ID, IdempotencyTokenTrait.ID, IdempotentTrait.ID, JsonNameTrait.ID, LengthTrait.ID, NoReplaceTrait.ID, MediaTypeTrait.ID, PaginatedTrait.ID, PatternTrait.ID, PrivateTrait.ID, ProtocolDefinitionTrait.ID, AuthDefinitionTrait.ID, HttpApiKeyAuthTrait.ID, HttpBasicAuthTrait.ID, HttpDigestAuthTrait.ID, HttpBearerAuthTrait.ID, OptionalAuthTrait.ID, RangeTrait.ID, ReadonlyTrait.ID, ReferencesTrait.ID, RequiresLengthTrait.ID, RequiredTrait.ID, ResourceIdentifierTrait.ID, RetryableTrait.ID, SensitiveTrait.ID, SinceTrait.ID, StreamingTrait.ID, SuppressTrait.ID, TagsTrait.ID, TimestampFormatTrait.ID, TitleTrait.ID, TraitDefinition.ID, UniqueItemsTrait.ID, UnstableTrait.ID, XmlAttributeTrait.ID, XmlFlattenedTrait.ID, XmlNameTrait.ID, XmlNamespaceTrait.ID});
    private static final Set<ShapeId> PUBLIC_PRELUDE_SHAPE_IDS = (Set)PUBLIC_PRELUDE_SHAPES.stream().map(AbstractShapeBuilder::getId).collect(SetUtils.toUnmodifiableSet());

    private Prelude() {
    }

    public static boolean isPreludeShape(ToShapeId id) {
        return id.toShapeId().getNamespace().equals(NAMESPACE);
    }

    public static boolean isPublicPreludeShape(ToShapeId id) {
        ShapeId toId = id.toShapeId();
        return PUBLIC_PRELUDE_SHAPE_IDS.contains(toId) || PRELUDE_TRAITS.contains(toId);
    }

    static boolean isImmutablePublicPreludeShape(ToShapeId id) {
        return PUBLIC_PRELUDE_SHAPE_IDS.contains(id.toShapeId());
    }

    static Model getPreludeModel() {
        return PreludeHolder.PRELUDE;
    }

    private static final class PreludeHolder {
        private static final Model PRELUDE = PreludeHolder.loadPrelude();

        private PreludeHolder() {
        }

        private static Model loadPrelude() {
            LoaderVisitor visitor = new LoaderVisitor(ModelAssembler.LazyTraitFactoryHolder.INSTANCE);
            for (AbstractShapeBuilder builder : PUBLIC_PRELUDE_SHAPES) {
                visitor.onShape(builder);
            }
            String filename = "prelude-traits.smithy";
            IdlModelLoader.load(filename, () -> Prelude.class.getResourceAsStream(filename), visitor);
            Model preludeModel = visitor.onEnd().unwrap();
            for (Shape trait : preludeModel.getShapesWithTrait(TraitDefinition.class)) {
                if (PRELUDE_TRAITS.contains(trait.getId())) continue;
                throw new IllegalStateException("PRELUDE_TRAITS property of prelude is inconsistent with the traits defined in the prelude-traits.smithy file. This property MUST be kept consistent with the file. " + PRELUDE_TRAITS + " in PRELUDE_TRAITS vs " + preludeModel.getShapesWithTrait(TraitDefinition.class).stream().map(Shape::getId).collect(Collectors.toList()));
            }
            return preludeModel;
        }
    }
}

