/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.TopDownIndex;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;

public class SingleResourceBindingValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        TopDownIndex topDownIndex = model.getKnowledge(TopDownIndex.class);
        return model.shapes(ServiceShape.class).flatMap(shape -> this.validateService(topDownIndex, (ServiceShape)shape).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateService(TopDownIndex topDownIndex, ServiceShape service) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ResourceShape resource : topDownIndex.getContainedResources(service)) {
            HashSet<ShapeId> containers = new HashSet<ShapeId>();
            if (service.getResources().contains(resource.getId())) {
                containers.add(service.getId());
            }
            for (ResourceShape otherResource : topDownIndex.getContainedResources(service)) {
                if (!otherResource.getResources().contains(resource.getId())) continue;
                containers.add(otherResource.getId());
            }
            if (containers.size() <= 1) continue;
            events.add(this.error(resource, String.format("A resource can appear only once in an entire service closure. This resource is illegally bound into the `%s` service closure from multiple shapes: [%s]", service.getId(), ValidationUtils.tickedList(containers))));
        }
        return events;
    }
}

