/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.SetShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;

public class ShapeRecursionValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        return model.shapes().map(shape -> this.validateShape(model, (Shape)shape)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ValidationEvent validateShape(Model model, Shape shape) {
        return new RecursiveNeighborVisitor(model, shape).visit(shape);
    }

    private final class RecursiveNeighborVisitor
    extends ShapeVisitor.Default<ValidationEvent> {
        private final Model model;
        private final Shape root;
        private final Set<ShapeId> visited = new HashSet<ShapeId>();
        private final Deque<String> context = new ArrayDeque<String>();

        RecursiveNeighborVisitor(Model model, Shape root) {
            this.root = root;
            this.model = model;
        }

        ValidationEvent visit(Shape shape) {
            ValidationEvent event = this.hasShapeBeenVisited(shape);
            return event != null ? event : shape.accept(this);
        }

        private ValidationEvent hasShapeBeenVisited(Shape shape) {
            if (!this.visited.contains(shape.getId())) {
                return null;
            }
            return ShapeRecursionValidator.this.error(shape, String.format("Found invalid shape recursion: %s. A recursive list, set, or map shape is only valid if an intermediate reference is through a union or structure.", String.join((CharSequence)" > ", this.context)));
        }

        @Override
        protected ValidationEvent getDefault(Shape shape) {
            return null;
        }

        @Override
        public ValidationEvent listShape(ListShape shape) {
            return this.validateMember(shape, shape.getMember());
        }

        @Override
        public ValidationEvent setShape(SetShape shape) {
            return this.validateMember(shape, shape.getMember());
        }

        @Override
        public ValidationEvent mapShape(MapShape shape) {
            return this.validateMember(shape, shape.getValue());
        }

        private ValidationEvent validateMember(Shape container, MemberShape member) {
            ValidationEvent event = null;
            Shape target = this.model.getShape(member.getTarget()).orElse(null);
            if (target != null) {
                this.visited.add(container.getId());
                this.context.addLast(member.getId().toString());
                this.context.addLast(member.getTarget().toString());
                event = this.visit(target);
                this.context.removeLast();
                this.context.removeLast();
                this.visited.remove(container.getId());
            }
            return event;
        }
    }
}

