/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.traits.HttpHeaderTrait;
import software.amazon.smithy.model.traits.HttpPrefixHeadersTrait;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.Pair;

public final class HttpPrefixHeadersTraitValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        return model.shapes(StructureShape.class).flatMap(shape -> this.validateStructure((StructureShape)shape).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateStructure(StructureShape structure) {
        Pair prefixPair = structure.getAllMembers().values().stream().flatMap(shape -> Trait.flatMapStream(shape, HttpPrefixHeadersTrait.class)).findFirst().orElse(null);
        if (prefixPair == null) {
            return ListUtils.of();
        }
        String prefix = ((HttpPrefixHeadersTrait)prefixPair.getRight()).getValue().toLowerCase(Locale.US);
        return structure.getAllMembers().values().stream().flatMap(member -> Trait.flatMapStream(member, HttpHeaderTrait.class)).map(pair -> Pair.of((Object)((MemberShape)pair.getLeft()), (Object)((HttpHeaderTrait)pair.getRight()).getValue().toLowerCase(Locale.US))).filter(pair -> ((String)pair.getRight()).startsWith(prefix)).map(pair -> this.error((Shape)pair.getLeft(), String.format("`httpHeader` binding of `%s` conflicts with the `httpPrefixHeaders` binding of `%s` to `%s`. `httpHeader` bindings must not case-insensitively start with any `httpPrefixHeaders` bindings.", pair.getRight(), ((MemberShape)prefixPair.getLeft()).getId(), prefix))).collect(Collectors.toList());
    }
}

