/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.node;

import java.util.List;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.traits.PatternTrait;
import software.amazon.smithy.model.validation.node.MemberAndShapeTraitPlugin;
import software.amazon.smithy.utils.ListUtils;

public final class PatternTraitPlugin
extends MemberAndShapeTraitPlugin<StringShape, StringNode, PatternTrait> {
    public PatternTraitPlugin() {
        super(StringShape.class, StringNode.class, PatternTrait.class);
    }

    @Override
    protected List<String> check(Shape shape, PatternTrait trait, StringNode node, ShapeIndex index) {
        if (!trait.getPattern().matcher(node.getValue()).find()) {
            return ListUtils.of((Object)String.format("String value provided for `%s` must match regular expression: %s", shape.getId(), trait.getPattern().pattern()));
        }
        return ListUtils.of();
    }
}

