/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.OptionalUtils;

public final class ResourceCycleValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        ShapeIndex shapeIndex = model.getShapeIndex();
        return shapeIndex.shapes(ResourceShape.class).flatMap(shape -> OptionalUtils.stream(this.detectCycles(shapeIndex, (ResourceShape)shape, (Set<ShapeId>)new LinkedHashSet<ShapeId>()))).collect(Collectors.toList());
    }

    private Optional<ValidationEvent> detectCycles(ShapeIndex index, ResourceShape resource, Set<ShapeId> visited) {
        if (visited.contains(resource.getId())) {
            return Optional.of(this.cycle(resource, visited));
        }
        visited.add(resource.getId());
        for (ShapeId child : resource.getResources()) {
            Optional<ValidationEvent> error;
            ResourceShape childResource = index.getShape(child).flatMap(Shape::asResourceShape).orElse(null);
            if (childResource == null || !(error = this.detectCycles(index, childResource, visited)).isPresent()) continue;
            return error;
        }
        return Optional.empty();
    }

    private ValidationEvent cycle(ResourceShape shape, Set<ShapeId> parents) {
        String chain = parents.stream().map(ShapeId::toString).collect(Collectors.joining(" -> "));
        return this.error(shape, String.format("Circular resource hierarchy found: %s -> %s", chain, shape.getId()));
    }
}

