/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Collections;
import java.util.stream.Stream;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;

public interface Trait
extends FromSourceLocation,
ToNode,
ToShapeId {
    @Override
    public ShapeId toShapeId();

    public static <S extends Shape, T extends Trait> Stream<Pair<S, T>> flatMapStream(S shape, Class<T> traitClass) {
        return OptionalUtils.stream(shape.getTrait(traitClass).map(t -> Pair.of((Object)shape, (Object)t)));
    }

    public static String getIdiomaticTraitName(String traitName) {
        return traitName.replace("smithy.api#", "");
    }

    public static String getIdiomaticTraitName(ToShapeId id) {
        return Trait.getIdiomaticTraitName(id.toShapeId().toString());
    }

    public static String makeAbsoluteName(String traitName) {
        return Trait.makeAbsoluteName(traitName, "smithy.api");
    }

    public static String makeAbsoluteName(String traitName, String defaultNamespace) {
        return traitName.contains("#") ? traitName : defaultNamespace + "#" + traitName;
    }

    public static Node coerceTraitValue(Node value, ShapeType targetType) {
        if (value.isNullNode()) {
            if (targetType == null) {
                return new BooleanNode(true, value.getSourceLocation());
            }
            if (targetType == ShapeType.STRUCTURE || targetType == ShapeType.MAP) {
                return new ObjectNode(Collections.emptyMap(), value.getSourceLocation());
            }
            if (targetType == ShapeType.LIST || targetType == ShapeType.SET) {
                return new ArrayNode(Collections.emptyList(), value.getSourceLocation());
            }
        } else if (targetType == ShapeType.STRUCTURE && value.asBooleanNode().filter(BooleanNode::getValue).isPresent()) {
            return new ObjectNode(Collections.emptyMap(), value.getSourceLocation());
        }
        return value;
    }
}

