/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.Tagged;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class EnumConstantBody
implements ToSmithyBuilder<EnumConstantBody>,
Tagged {
    public static final String NAME = "name";
    public static final String DOCUMENTATION = "documentation";
    public static final String TAGS = "tags";
    private final String documentation;
    private final List<String> tags;
    private final String name;

    private EnumConstantBody(Builder builder) {
        this.documentation = builder.documentation;
        this.tags = new ArrayList<String>(builder.tags);
        this.name = builder.name;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<String> getDocumentation() {
        return Optional.ofNullable(this.documentation);
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return EnumConstantBody.builder().tags(this.tags).documentation(this.documentation).name(this.name);
    }

    public boolean equals(Object other) {
        if (!(other instanceof EnumConstantBody)) {
            return false;
        }
        EnumConstantBody otherEnum = (EnumConstantBody)other;
        return Objects.equals(this.name, otherEnum.name) && Objects.equals(this.documentation, otherEnum.documentation) && this.tags.equals(otherEnum.tags);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.tags, this.documentation);
    }

    public static final class Builder
    implements SmithyBuilder<EnumConstantBody> {
        private String documentation;
        private String name;
        private final List<String> tags = new ArrayList<String>();

        public EnumConstantBody build() {
            return new EnumConstantBody(this);
        }

        public Builder documentation(String documentation) {
            this.documentation = documentation;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder tags(Collection<String> tags) {
            this.tags.clear();
            this.tags.addAll(tags);
            return this;
        }

        public Builder addTag(String tag) {
            this.tags.add(tag);
            return this;
        }

        public Builder clearTags() {
            this.tags.clear();
            return this;
        }
    }
}

