/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ShapeIndex
implements ToSmithyBuilder<ShapeIndex> {
    private static final int GROUP_CACHE_THRESHOLD = 50;
    private final Map<ShapeId, Shape> shapeMap;
    private final ShapeGrouper shapeGrouper;
    private int hash;

    private ShapeIndex(Builder builder) {
        this.shapeMap = MapUtils.copyOf((Map)builder.shapeMap);
        this.shapeGrouper = this.shapeMap.size() >= 50 ? new CachedShapeGrouper() : ShapeIndex::passThroughGrouper;
    }

    private static <T extends Shape> Stream<T> passThroughGrouper(Stream<Shape> shapes, Class<T> shapeType) {
        return shapes.filter(value -> value.getClass() == shapeType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ShapeIndex.builder().addShapes(this);
    }

    public Optional<Shape> getShape(ShapeId id) {
        return Optional.ofNullable(this.shapeMap.get(id));
    }

    public Stream<Shape> shapes() {
        return this.shapeMap.values().stream();
    }

    public <T extends Shape> Stream<T> shapes(Class<T> shapeType) {
        return this.shapeGrouper.shapes(this.shapes(), shapeType);
    }

    public Set<Shape> toSet() {
        return new AbstractSet<Shape>(){

            @Override
            public int size() {
                return ShapeIndex.this.shapeMap.size();
            }

            @Override
            public boolean contains(Object o) {
                return o instanceof Shape && ShapeIndex.this.shapeMap.containsKey(((Shape)o).getId());
            }

            @Override
            public Iterator<Shape> iterator() {
                return ShapeIndex.this.shapeMap.values().iterator();
            }
        };
    }

    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            this.hash = result = this.shapeMap.keySet().hashCode();
        }
        return result;
    }

    public boolean equals(Object other) {
        return other instanceof ShapeIndex && this.shapeMap.equals(((ShapeIndex)other).shapeMap);
    }

    public static final class Builder
    implements SmithyBuilder<ShapeIndex> {
        private final Map<ShapeId, Shape> shapeMap = new HashMap<ShapeId, Shape>();

        private Builder() {
        }

        public ShapeIndex build() {
            return new ShapeIndex(this);
        }

        public Builder addShape(Shape shape) {
            this.shapeMap.put(shape.getId(), shape);
            return this;
        }

        public Builder addShapes(ShapeIndex shapeIndex) {
            shapeIndex.shapes().forEach(this::addShape);
            return this;
        }

        public Builder addShapes(Collection<Shape> shapes) {
            shapes.forEach(this::addShape);
            return this;
        }

        public Builder addShapes(Shape ... shapes) {
            for (Shape shape : shapes) {
                this.addShape(shape);
            }
            return this;
        }

        public Builder removeShape(ShapeId shapeId) {
            this.shapeMap.remove(shapeId);
            return this;
        }
    }

    private static final class CachedShapeGrouper
    implements ShapeGrouper {
        private final Map<Class<? extends Shape>, List<Shape>> grouped = new ConcurrentHashMap<Class<? extends Shape>, List<Shape>>();

        private CachedShapeGrouper() {
        }

        @Override
        public <T extends Shape> Stream<T> shapes(Stream<Shape> shapes, Class<T> shapeType) {
            return this.grouped.computeIfAbsent(shapeType, t -> ShapeIndex.passThroughGrouper(shapes, shapeType).collect(Collectors.toList())).stream();
        }
    }

    @FunctionalInterface
    private static interface ShapeGrouper {
        public <T extends Shape> Stream<T> shapes(Stream<Shape> var1, Class<T> var2);
    }
}

