/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.List;
import java.util.Set;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.SetUtils;

final class AndSelector
implements Selector {
    private final List<Selector> selectors;

    private AndSelector(List<Selector> predicates) {
        this.selectors = predicates;
    }

    static Selector of(List<Selector> predicates) {
        return predicates.size() == 1 ? predicates.get(0) : new AndSelector(predicates);
    }

    @Override
    public Set<Shape> select(NeighborProvider neighborProvider, Set<Shape> shapes) {
        for (Selector selector : this.selectors) {
            shapes = selector.select(neighborProvider, shapes);
            if (!shapes.isEmpty()) continue;
            return SetUtils.of();
        }
        return shapes;
    }
}

