/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.knowledge.NeighborProviderIndex;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipDirection;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.SetUtils;

public class TargetValidator
extends AbstractValidator {
    private static final Set<ShapeType> INVALID_MEMBER_TARGETS = SetUtils.of((Object[])new ShapeType[]{ShapeType.SERVICE, ShapeType.RESOURCE, ShapeType.OPERATION, ShapeType.MEMBER});
    private static final Set<ShapeType> INVALID_RECURSIVE_MEMBER_TARGETS = SetUtils.of((Object[])new ShapeType[]{ShapeType.LIST, ShapeType.SET});

    @Override
    public List<ValidationEvent> validate(Model model) {
        ShapeIndex index = model.getShapeIndex();
        NeighborProvider neighborProvider = model.getKnowledge(NeighborProviderIndex.class).getProvider();
        return index.shapes().flatMap(shape -> this.validateShape(index, (Shape)shape, neighborProvider.getNeighbors((Shape)shape))).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateShape(ShapeIndex index, Shape shape, List<Relationship> relationships) {
        return relationships.stream().flatMap(relationship -> {
            if (relationship.getNeighborShape().isPresent()) {
                return OptionalUtils.stream(this.validateTarget(index, shape, relationship.getNeighborShape().get(), (Relationship)relationship));
            }
            return Stream.of(this.unresolvedTarget(shape, (Relationship)relationship));
        });
    }

    private Optional<ValidationEvent> validateTarget(ShapeIndex index, Shape shape, Shape target, Relationship rel) {
        RelationshipType relType = rel.getRelationshipType();
        if (relType.getDirection() == RelationshipDirection.DIRECTED && target.hasTrait(TraitDefinition.class)) {
            return Optional.of(this.error(shape, String.format("Found a %s reference to trait definition `%s`. Trait definitions cannot be targeted by members or referenced by shapes in any other context other than applying them as traits.", new Object[]{relType, rel.getNeighborShapeId()})));
        }
        switch (relType) {
            case MEMBER_TARGET: {
                if (INVALID_MEMBER_TARGETS.contains((Object)target.getType())) {
                    return Optional.of(this.error(shape, String.format("Members cannot target %s shapes, but found %s", new Object[]{target.getType(), target})));
                }
                if (target.getId().equals(shape.getId().withoutMember()) && INVALID_RECURSIVE_MEMBER_TARGETS.contains((Object)target.getType())) {
                    return Optional.of(this.error(shape, String.format("%s shape members cannot target their container", new Object[]{target.getType()})));
                }
            }
            case MAP_KEY: {
                return target.asMemberShape().flatMap(m -> this.validateMapKey(shape, m.getTarget(), index));
            }
            case RESOURCE: {
                if (target.getType() != ShapeType.RESOURCE) {
                    return Optional.of(this.badType(shape, target, relType, ShapeType.RESOURCE));
                }
                return Optional.empty();
            }
            case OPERATION: {
                if (target.getType() != ShapeType.OPERATION) {
                    return Optional.of(this.badType(shape, target, relType, ShapeType.OPERATION));
                }
                return Optional.empty();
            }
            case INPUT: 
            case OUTPUT: {
                if (target.getType() != ShapeType.STRUCTURE) {
                    return Optional.of(this.badType(shape, target, relType, ShapeType.STRUCTURE));
                }
                if (target.findTrait("error").isPresent()) {
                    return Optional.of(this.inputOutputWithErrorTrait(shape, target, rel.getRelationshipType()));
                }
                return Optional.empty();
            }
            case ERROR: {
                if (target.getType() != ShapeType.STRUCTURE) {
                    return Optional.of(this.badType(shape, target, relType, ShapeType.STRUCTURE));
                }
                if (!target.findTrait("error").isPresent()) {
                    return Optional.of(this.errorNoTrait(shape, target.getId()));
                }
                return Optional.empty();
            }
            case IDENTIFIER: {
                return this.validateIdentifier(shape, target);
            }
            case CREATE: 
            case READ: 
            case UPDATE: 
            case DELETE: 
            case LIST: {
                if (target.getType() != ShapeType.OPERATION) {
                    return Optional.of(this.error(shape, String.format("Resource %s lifecycle operation must target an operation, but found %s", relType.toString().toLowerCase(Locale.US), target)));
                }
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Optional<ValidationEvent> validateMapKey(Shape shape, ShapeId target, ShapeIndex index) {
        return index.getShape(target).filter(FunctionalUtils.not(Shape::isStringShape)).map(resolved -> this.error(shape, String.format("Map key member targets %s, but is expected to target a string", resolved)));
    }

    private Optional<ValidationEvent> validateIdentifier(Shape shape, Shape target) {
        if (target.getType() != ShapeType.STRING) {
            return Optional.of(this.badType(shape, target, RelationshipType.IDENTIFIER, ShapeType.STRING));
        }
        return Optional.empty();
    }

    private ValidationEvent unresolvedTarget(Shape shape, Relationship rel) {
        if (rel.getRelationshipType() == RelationshipType.MEMBER_TARGET) {
            return this.error(shape, String.format("member shape targets an unresolved shape `%s`", rel.getNeighborShapeId()));
        }
        return this.error(shape, String.format("%s shape has a `%s` relationship to an unresolved shape `%s`", new Object[]{shape.getType(), rel.getRelationshipType().toString().toLowerCase(Locale.US), rel.getNeighborShapeId()}));
    }

    private ValidationEvent badType(Shape shape, Shape target, RelationshipType rel, ShapeType valid) {
        return this.error(shape, String.format("%s shape `%s` relationships must target a %s shape, but found %s", new Object[]{shape.getType(), rel.toString().toLowerCase(Locale.US), valid, target}));
    }

    private ValidationEvent inputOutputWithErrorTrait(Shape shape, Shape target, RelationshipType rel) {
        String descriptor = rel == RelationshipType.INPUT ? "input" : "output";
        return this.error(shape, String.format("Operation %s targets an invalid structure `%s` that is marked with the `error` trait.", descriptor, target.getId()));
    }

    private ValidationEvent errorNoTrait(Shape shape, ShapeId target) {
        return this.error(shape, String.format("Operation error targets an invalid structure, `%s`, that is not marked with the `error` trait.", target));
    }
}

