/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.validation.validators;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.OptionalUtils;

public final class ResourceIdentifierValidator
extends AbstractValidator {
    @Override
    public List<ValidationEvent> validate(Model model) {
        return model.getShapeIndex().shapes(ResourceShape.class).flatMap(resource -> this.validateAgainstChildren((ResourceShape)resource, model.getShapeIndex())).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateAgainstChildren(ResourceShape resource, ShapeIndex index) {
        return resource.getResources().stream().flatMap(shape -> OptionalUtils.stream(index.getShape((ShapeId)shape).flatMap(Shape::asResourceShape))).flatMap(child -> Stream.concat(OptionalUtils.stream(this.checkForMissing((ResourceShape)child, resource)), OptionalUtils.stream(this.checkForMismatches((ResourceShape)child, resource))));
    }

    private Optional<ValidationEvent> checkForMissing(ResourceShape resource, ResourceShape parent) {
        String missingKeys = parent.getIdentifiers().entrySet().stream().filter(entry -> resource.getIdentifiers().get(entry.getKey()) == null).map(Map.Entry::getKey).sorted().collect(Collectors.joining(", "));
        if (missingKeys.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.error(resource, String.format("This resource is bound as a child of `%s`, but it is invalid because its `identifiers` property is missing the following identifiers that are defined in `%s`: [%s]", parent.getId(), parent.getId(), missingKeys)));
    }

    private Optional<ValidationEvent> checkForMismatches(ResourceShape resource, ResourceShape parent) {
        String mismatchedTargets = parent.getIdentifiers().entrySet().stream().filter(entry -> resource.getIdentifiers().get(entry.getKey()) != null).filter(entry -> !resource.getIdentifiers().get(entry.getKey()).equals(entry.getValue())).map(entry -> String.format("expected the `%s` member to target `%s`, but found a target of `%s`", entry.getKey(), entry.getValue(), resource.getIdentifiers().get(entry.getKey()))).sorted().collect(Collectors.joining("; "));
        if (mismatchedTargets.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.error(resource, String.format("The `identifiers` property of this resource is incompatible with its binding to `%s`: %s", parent.getId(), mismatchedTargets)));
    }
}

