/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ReferencesTrait
extends AbstractTrait
implements ToSmithyBuilder<ReferencesTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#references");
    private final List<Reference> references;

    private ReferencesTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.references = ListUtils.copyOf((Collection)builder.references);
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    public List<Reference> getResourceReferences(ShapeId shapeId) {
        return this.getReferences().stream().filter(reference -> reference.getResource().equals(shapeId)).collect(Collectors.toList());
    }

    @Override
    protected Node createNode() {
        return this.references.stream().map(Reference::toNode).collect(ArrayNode.collect());
    }

    public Builder toBuilder() {
        Builder builder = (Builder)new Builder().sourceLocation(this.getSourceLocation());
        this.references.forEach(builder::addReference);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public ReferencesTrait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)ReferencesTrait.builder().sourceLocation(value);
            ArrayNode refs = value.expectArrayNode();
            for (ObjectNode member : refs.getElementsAs(ObjectNode.class)) {
                builder.addReference(Provider.referenceFromNode(target.getNamespace(), member));
            }
            return builder.build();
        }

        private static Reference referenceFromNode(String namespace, ObjectNode referenceProperties) {
            return Reference.builder().resource(referenceProperties.expectStringMember("resource").expectShapeId(namespace)).ids(referenceProperties.getObjectMember("ids").map(obj -> obj.getMembers().entrySet().stream().map(entry -> Pair.of((Object)((StringNode)entry.getKey()).getValue(), (Object)((Node)entry.getValue()).expectStringNode().getValue())).collect(Collectors.toMap(Pair::getLeft, Pair::getRight))).orElseGet(Collections::emptyMap)).service(referenceProperties.getStringMember("service").map(string -> string.expectShapeId(namespace)).orElse(null)).rel(referenceProperties.getStringMember("rel").map(StringNode::getValue).orElse(null)).build();
        }
    }

    public static final class Reference
    implements ToSmithyBuilder<Reference>,
    ToNode {
        private ShapeId resource;
        private Map<String, String> ids;
        private ShapeId service;
        private String rel;

        private Reference(Builder builder) {
            this.resource = (ShapeId)SmithyBuilder.requiredState((String)"resource", (Object)builder.resource);
            this.ids = Collections.unmodifiableMap(new TreeMap(builder.ids));
            this.rel = builder.rel;
            this.service = builder.service;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return Reference.builder().resource(this.resource).ids(this.ids).service(this.service).rel(this.rel);
        }

        public ShapeId getResource() {
            return this.resource;
        }

        public Optional<ShapeId> getService() {
            return Optional.ofNullable(this.service);
        }

        public Map<String, String> getIds() {
            return this.ids;
        }

        public Optional<String> getRel() {
            return Optional.ofNullable(this.rel);
        }

        public String toString() {
            return "Reference" + Node.printJson(this.toNode());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Reference)) {
                return false;
            }
            Reference reference = (Reference)o;
            return this.resource.equals(reference.resource) && Objects.equals(this.ids, reference.ids) && Objects.equals(this.service, reference.service) && Objects.equals(this.rel, reference.rel);
        }

        public int hashCode() {
            return Objects.hash(this.resource, this.ids, this.service, this.rel);
        }

        @Override
        public Node toNode() {
            return Node.objectNodeBuilder().withMember("resource", Node.from(this.resource.toString())).withOptionalMember("ids", this.ids.isEmpty() ? Optional.empty() : Optional.of(ObjectNode.fromStringMap(this.getIds()))).withOptionalMember("service", this.getService().map(ShapeId::toString).map(Node::from)).withOptionalMember("rel", this.getRel().map(Node::from)).build();
        }

        public static final class Builder
        implements SmithyBuilder<Reference> {
            private ShapeId resource;
            private String rel;
            private Map<String, String> ids = MapUtils.of();
            private ShapeId service;

            private Builder() {
            }

            public Reference build() {
                return new Reference(this);
            }

            public Builder ids(Map<String, String> members) {
                this.ids = Objects.requireNonNull(members);
                return this;
            }

            public Builder resource(ShapeId resource) {
                this.resource = Objects.requireNonNull(resource);
                return this;
            }

            public Builder service(ShapeId service) {
                this.service = service;
                return this;
            }

            public Builder rel(String rel) {
                this.rel = rel;
                return this;
            }
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<ReferencesTrait, Builder> {
        private List<Reference> references = new ArrayList<Reference>();

        public Builder addReference(Reference reference) {
            this.references.add(Objects.requireNonNull(reference));
            return this;
        }

        public Builder clearReferences() {
            this.references.clear();
            return this;
        }

        public Builder references(List<Reference> references) {
            this.references.clear();
            this.references.addAll(references);
            return this;
        }

        public ReferencesTrait build() {
            return new ReferencesTrait(this);
        }
    }
}

