/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.Tagged;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Protocol
implements ToNode,
ToSmithyBuilder<Protocol>,
Tagged {
    private final String name;
    private final List<String> auth;
    private final List<String> tags;
    private Node node;

    private Protocol(Builder builder) {
        this.name = (String)SmithyBuilder.requiredState((String)"name", (Object)builder.name);
        this.auth = ListUtils.copyOf((Collection)builder.auth);
        this.tags = ListUtils.copyOf((Collection)builder.tags);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAuth() {
        return this.auth;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Builder toBuilder() {
        Builder builder = Protocol.builder().name(this.name);
        this.tags.forEach(builder::addTag);
        this.auth.forEach(builder::addAuth);
        return builder;
    }

    @Override
    public Node toNode() {
        if (this.node == null) {
            this.node = Node.objectNodeBuilder().withMember("name", this.name).withOptionalMember("tags", !this.tags.isEmpty() ? Optional.of(ArrayNode.fromStrings(this.tags)) : Optional.empty()).withOptionalMember("auth", !this.auth.isEmpty() ? Optional.of(ArrayNode.fromStrings(this.auth)) : Optional.empty()).build();
        }
        return this.node;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Protocol)) {
            return false;
        }
        Protocol protocol = (Protocol)o;
        return this.name.equals(protocol.name) && this.auth.equals(protocol.auth) && this.tags.equals(protocol.tags);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.auth, this.tags);
    }

    public static final class Builder
    implements SmithyBuilder<Protocol> {
        private String name;
        private final List<String> auth = new ArrayList<String>();
        private final List<String> tags = new ArrayList<String>();

        public Protocol build() {
            return new Protocol(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder addAuth(String value) {
            this.auth.add(value);
            return this;
        }

        public Builder removeAuth(String value) {
            this.auth.remove(value);
            return this;
        }

        public Builder clearAuth() {
            this.auth.clear();
            return this;
        }

        public Builder addTag(String tag) {
            this.tags.add(tag);
            return this;
        }

        public Builder removeTag(String tag) {
            this.tags.remove(tag);
            return this;
        }

        public Builder clearTags() {
            this.tags.clear();
            return this;
        }
    }
}

