/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.Locale;
import java.util.Set;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.utils.SetUtils;

public final class HttpHeaderTrait
extends StringTrait {
    public static final ShapeId ID = ShapeId.from("smithy.api#httpHeader");
    private static final Set<String> BLACKLIST = SetUtils.of((Object[])new String[]{"authorization", "connection", "content-length", "expect", "host", "max-forwards", "proxy-authenticate", "server", "te", "trailer", "transfer-encoding", "upgrade", "user-agent", "www-authenticate", "x-forwarded-for"});

    public HttpHeaderTrait(String value, SourceLocation sourceLocation) {
        super(ID, value, sourceLocation);
        if (this.getValue().isEmpty()) {
            throw new SourceException("httpHeader field name binding must not be empty", this.getSourceLocation());
        }
        if (BLACKLIST.contains(this.getValue().toLowerCase(Locale.US))) {
            throw new SourceException("httpHeader cannot be set to `" + this.getValue() + "`", this.getSourceLocation());
        }
    }

    public HttpHeaderTrait(String value) {
        this(value, SourceLocation.NONE);
    }

    public static final class Provider
    extends StringTrait.Provider<HttpHeaderTrait> {
        public Provider() {
            super(ID, HttpHeaderTrait::new);
        }
    }
}

