/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.selector;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.neighbor.NeighborProvider;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.neighbor.RelationshipType;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.OptionalUtils;

final class NeighborSelector
implements Selector {
    private final List<String> relTypes;

    NeighborSelector(List<String> relTypes) {
        this.relTypes = relTypes;
    }

    @Override
    public Set<Shape> select(NeighborProvider neighborProvider, Set<Shape> shapes) {
        return shapes.stream().flatMap(shape -> neighborProvider.getNeighbors((Shape)shape).stream().flatMap(this::mapNeighbor)).collect(Collectors.toSet());
    }

    private Stream<Shape> mapNeighbor(Relationship rel) {
        return OptionalUtils.stream(rel.getNeighborShape().flatMap(target -> this.createNeighbor(rel, (Shape)target)));
    }

    private Optional<Shape> createNeighbor(Relationship rel, Shape target) {
        if (rel.getRelationshipType() != RelationshipType.MEMBER_CONTAINER && (this.relTypes.isEmpty() || this.relTypes.contains(NeighborSelector.getRelType(rel)))) {
            return Optional.of(target);
        }
        return Optional.empty();
    }

    private static String getRelType(Relationship rel) {
        return rel.getSelectorLabel().orElse("");
    }
}

