/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.loader.LoaderVisitor;
import software.amazon.smithy.model.loader.ModelDiscovery;
import software.amazon.smithy.model.loader.ModelImportException;
import software.amazon.smithy.model.loader.ModelLoader;
import software.amazon.smithy.model.loader.ModelValidator;
import software.amazon.smithy.model.loader.NodeModelLoader;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.TraitFactory;
import software.amazon.smithy.model.validation.Suppression;
import software.amazon.smithy.model.validation.ValidatedResult;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.Validator;
import software.amazon.smithy.model.validation.ValidatorFactory;
import software.amazon.smithy.utils.IoUtils;
import software.amazon.smithy.utils.ListUtils;

public final class ModelAssembler {
    public static final String ALLOW_UNKNOWN_TRAITS = "assembler.allowUnknownTraits";
    private static final Logger LOGGER = Logger.getLogger(ModelAssembler.class.getName());
    private static final ModelLoader DEFAULT_LOADER = ModelLoader.createDefaultLoader();
    private TraitFactory traitFactory;
    private ValidatorFactory validatorFactory;
    private ModelLoader modelLoader = DEFAULT_LOADER;
    private final Map<String, Supplier<String>> stringModels = new HashMap<String, Supplier<String>>();
    private final List<Validator> validators = new ArrayList<Validator>();
    private final List<Suppression> suppressions = new ArrayList<Suppression>();
    private final List<Node> documentNodes = new ArrayList<Node>();
    private final List<Model> mergeModels = new ArrayList<Model>();
    private final List<AbstractShapeBuilder<?, ?>> shapes = new ArrayList();
    private final Map<String, Node> metadata = new HashMap<String, Node>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private boolean disablePrelude;

    public ModelAssembler copy() {
        ModelAssembler assembler = new ModelAssembler();
        assembler.traitFactory = this.traitFactory;
        assembler.validatorFactory = this.validatorFactory;
        assembler.modelLoader = this.modelLoader;
        assembler.stringModels.putAll(this.stringModels);
        assembler.validators.addAll(this.validators);
        assembler.suppressions.addAll(this.suppressions);
        assembler.documentNodes.addAll(this.documentNodes);
        assembler.mergeModels.addAll(this.mergeModels);
        assembler.shapes.addAll(this.shapes);
        assembler.metadata.putAll(this.metadata);
        assembler.disablePrelude = this.disablePrelude;
        assembler.properties.putAll(this.properties);
        return assembler;
    }

    public ModelAssembler reset() {
        this.shapes.clear();
        this.metadata.clear();
        this.mergeModels.clear();
        this.stringModels.clear();
        this.validators.clear();
        this.suppressions.clear();
        this.documentNodes.clear();
        this.properties.clear();
        this.disablePrelude = false;
        return this;
    }

    public ModelAssembler traitFactory(TraitFactory traitFactory) {
        this.traitFactory = Objects.requireNonNull(traitFactory);
        return this;
    }

    public ModelAssembler validatorFactory(ValidatorFactory validatorFactory) {
        this.validatorFactory = Objects.requireNonNull(validatorFactory);
        return this;
    }

    public ModelAssembler addValidator(Validator validator) {
        this.validators.add(Objects.requireNonNull(validator));
        return this;
    }

    public ModelAssembler addSuppression(Suppression suppression) {
        this.suppressions.add(Objects.requireNonNull(suppression));
        return this;
    }

    public ModelAssembler addUnparsedModel(String sourceLocation, String model) {
        this.stringModels.put(sourceLocation, () -> model);
        return this;
    }

    public ModelAssembler addDocumentNode(Node document) {
        this.documentNodes.add(Objects.requireNonNull(document));
        return this;
    }

    public ModelAssembler addImport(String importPath) {
        return this.addImport(Paths.get(Objects.requireNonNull(importPath, "importPath must not be null"), new String[0]));
    }

    public ModelAssembler addImport(Path importPath) {
        Objects.requireNonNull(importPath, "The importPath provided to ModelAssembler#addImport was null");
        if (Files.isDirectory(importPath, new LinkOption[0])) {
            try {
                Files.walk(importPath, FileVisitOption.FOLLOW_LINKS).filter(p -> !p.equals(importPath)).filter(p -> Files.isDirectory(p, new LinkOption[0]) || Files.isRegularFile(p, new LinkOption[0])).forEach(this::addImport);
            }
            catch (IOException e) {
                throw new ModelImportException("Error loading the contents of " + importPath, e);
            }
        } else if (Files.isRegularFile(importPath, new LinkOption[0])) {
            this.stringModels.put(importPath.toString(), () -> IoUtils.readUtf8File((Path)importPath));
        } else {
            throw new ModelImportException("Cannot find import file: " + importPath);
        }
        return this;
    }

    public ModelAssembler addImport(URL url) {
        Objects.requireNonNull(url, "The provided url to ModelAssembler#addImport was null");
        this.stringModels.put(url.toExternalForm(), () -> {
            String string;
            block8: {
                InputStream inputStream = url.openStream();
                try {
                    string = IoUtils.toUtf8String((InputStream)inputStream);
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | UncheckedIOException e) {
                        throw new ModelImportException("Unable to open Smithy model import URL: " + url.toExternalForm(), e);
                    }
                }
                inputStream.close();
            }
            return string;
        });
        return this;
    }

    public ModelAssembler disablePrelude() {
        this.disablePrelude = true;
        return this;
    }

    public ModelAssembler addShape(Shape shape) {
        this.shapes.add((AbstractShapeBuilder<?, ?>)Shape.shapeToBuilder(shape));
        return this;
    }

    public ModelAssembler addShapes(Shape ... shapes) {
        for (Shape shape : shapes) {
            this.addShape(shape);
        }
        return this;
    }

    public ModelAssembler addModel(Model model) {
        this.mergeModels.add(model);
        return this;
    }

    public ModelAssembler putMetadata(String name, Node value) {
        this.metadata.put(Objects.requireNonNull(name), Objects.requireNonNull(value));
        return this;
    }

    public ModelAssembler discoverModels(ClassLoader loader) {
        return this.addDiscoveredModels(ModelDiscovery.findModels(loader));
    }

    public ModelAssembler discoverModels() {
        return this.addDiscoveredModels(ModelDiscovery.findModels());
    }

    private ModelAssembler addDiscoveredModels(List<URL> urls) {
        for (URL url : urls) {
            LOGGER.fine(() -> "Discovered Smithy model: " + url);
            this.addImport(url);
        }
        return this;
    }

    public ModelAssembler putProperty(String setting, Object value) {
        this.properties.put(setting, value);
        return this;
    }

    public ModelAssembler removeProperty(String setting) {
        this.properties.remove(setting);
        return this;
    }

    public ValidatedResult<Model> assemble() {
        try {
            return this.doAssemble();
        }
        catch (SourceException e) {
            return ValidatedResult.fromErrors(ListUtils.of((Object)ValidationEvent.fromSourceException(e)));
        }
    }

    private ValidatedResult<Model> doAssemble() {
        ValidatedResult<Model> modelResult;
        if (this.traitFactory == null) {
            this.traitFactory = LazyTraitFactoryHolder.INSTANCE;
        }
        LoaderVisitor visitor = new LoaderVisitor(this.traitFactory, this.properties);
        for (Map.Entry<String, Supplier<String>> modelEntry : this.stringModels.entrySet()) {
            if (this.modelLoader.load(modelEntry.getKey(), modelEntry.getValue(), visitor)) continue;
            LOGGER.warning(() -> "No ModelLoader was able to load " + (String)modelEntry.getKey());
        }
        if (!this.documentNodes.isEmpty()) {
            NodeModelLoader loader = new NodeModelLoader();
            for (Node node : this.documentNodes) {
                loader.load(visitor, node);
            }
        }
        this.shapes.forEach(visitor::onShape);
        this.metadata.forEach(visitor::onMetadata);
        for (Model model : this.mergeModels) {
            ModelAssembler.mergeModelIntoVisitor(model, visitor);
        }
        if (!this.disablePrelude) {
            ModelAssembler.mergeModelIntoVisitor(Prelude.getPreludeModel(), visitor);
        }
        return !(modelResult = visitor.onEnd()).getResult().isPresent() ? modelResult : this.validate(modelResult.getResult().get(), modelResult.getValidationEvents());
    }

    private static void mergeModelIntoVisitor(Model model, LoaderVisitor visitor) {
        visitor.onVersion(SourceLocation.NONE, model.getSmithyVersion());
        model.getMetadata().forEach(visitor::onMetadata);
        model.getShapeIndex().shapes().forEach(visitor::onShape);
    }

    private ValidatedResult<Model> validate(Model model, List<ValidationEvent> modelResultEvents) {
        if (this.validatorFactory == null) {
            this.validatorFactory = LazyValidatorFactoryHolder.INSTANCE;
        }
        List<ValidationEvent> events = ModelValidator.validate(model, this.validatorFactory, this.assembleValidators(), this.suppressions);
        events.addAll(modelResultEvents);
        return new ValidatedResult<Model>(model, events);
    }

    private List<Validator> assembleValidators() {
        ArrayList<Validator> copiedValidators = new ArrayList<Validator>(this.validatorFactory.loadBuiltinValidators());
        copiedValidators.addAll(this.validators);
        return copiedValidators;
    }

    static final class LazyTraitFactoryHolder {
        static final TraitFactory INSTANCE = TraitFactory.createServiceFactory(ModelAssembler.class.getClassLoader());

        LazyTraitFactoryHolder() {
        }
    }

    private static final class LazyValidatorFactoryHolder {
        static final ValidatorFactory INSTANCE = ValidatorFactory.createServiceFactory(ModelAssembler.class.getClassLoader());

        private LazyValidatorFactoryHolder() {
        }
    }
}

