/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.transform.plugins;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.shapes.ResourceShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.transform.ModelTransformer;
import software.amazon.smithy.model.transform.ModelTransformerPlugin;

public final class CleanBindings
implements ModelTransformerPlugin {
    @Override
    public Model onRemove(ModelTransformer transformer, Collection<Shape> shapes, Model model) {
        Set<ShapeId> removedResources = shapes.stream().filter(Shape::isResourceShape).map(Shape::getId).collect(Collectors.toSet());
        Set<ShapeId> removedOperations = shapes.stream().filter(Shape::isOperationShape).map(Shape::getId).collect(Collectors.toSet());
        Set<Shape> toReplace = this.getServicesToUpdate(model, removedResources, removedOperations);
        toReplace.addAll(this.getResourcesToUpdate(model, removedResources, removedOperations));
        return transformer.replaceShapes(model, toReplace);
    }

    private Set<Shape> getServicesToUpdate(Model model, Set<ShapeId> resources, Set<ShapeId> operations) {
        return model.getShapeIndex().shapes(ServiceShape.class).filter(service -> this.containsAny(service.getResources(), resources) || this.containsAny(service.getOperations(), operations)).map(service -> {
            ServiceShape.Builder builder = service.toBuilder();
            resources.forEach(builder::removeResource);
            operations.forEach(builder::removeOperation);
            return builder.build();
        }).collect(Collectors.toSet());
    }

    private Set<Shape> getResourcesToUpdate(Model model, Set<ShapeId> resources, Set<ShapeId> operations) {
        return model.getShapeIndex().shapes(ResourceShape.class).filter(resource -> this.containsAny(resource.getAllOperations(), operations) || this.containsAny(resource.getResources(), resources)).map(resource -> {
            ResourceShape.Builder builder = resource.toBuilder();
            resources.forEach(builder::removeResource);
            operations.forEach(builder::removeFromAllOperationBindings);
            return builder.build();
        }).collect(Collectors.toSet());
    }

    private boolean containsAny(Set<ShapeId> haystack, Set<ShapeId> needles) {
        HashSet<ShapeId> container = new HashSet<ShapeId>(haystack);
        container.retainAll(needles);
        return !container.isEmpty();
    }
}

