/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.BooleanNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.selector.SelectorSyntaxException;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.traits.TraitService;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.SetUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class TraitDefinition
extends AbstractTrait
implements ToSmithyBuilder<TraitDefinition> {
    public static final ShapeId ID = ShapeId.from("smithy.api#trait");
    public static final String SELECTOR_KEY = "selector";
    public static final String STRUCTURALLY_EXCLUSIVE_KEY = "structurallyExclusive";
    public static final String CONFLICTS_KEY = "conflicts";
    private static final Set<String> TRAIT_DEFINITION_PROPERTY_NAMES = SetUtils.of((Object[])new String[]{"selector", "structurallyExclusive", "conflicts"});
    private final Selector selector;
    private final List<ShapeId> conflicts;
    private final boolean structurallyExclusive;

    public TraitDefinition(Builder builder) {
        super(ID, builder.sourceLocation);
        this.selector = builder.selector;
        this.conflicts = ListUtils.copyOf((Collection)builder.conflicts);
        this.structurallyExclusive = builder.structurallyExclusive;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = TraitDefinition.builder().selector(this.selector).structurallyExclusive(this.structurallyExclusive);
        this.conflicts.forEach(builder::addConflict);
        return builder;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public List<ShapeId> getConflicts() {
        return this.conflicts;
    }

    public boolean isStructurallyExclusive() {
        return this.structurallyExclusive;
    }

    @Override
    protected Node createNode() {
        ObjectNode.Builder builder = Node.objectNodeBuilder().sourceLocation(this.getSourceLocation());
        if (this.selector != Selector.IDENTITY) {
            builder.withMember(SELECTOR_KEY, this.selector.toString());
        }
        if (!this.conflicts.isEmpty()) {
            builder.withMember(CONFLICTS_KEY, this.conflicts.stream().map(ShapeId::toString).map(Node::from).collect(ArrayNode.collect()));
        }
        if (this.isStructurallyExclusive()) {
            builder.withMember(STRUCTURALLY_EXCLUSIVE_KEY, Node.from(true));
        }
        return builder.build();
    }

    public static final class Provider
    implements TraitService {
        @Override
        public ShapeId getShapeId() {
            return ID;
        }

        @Override
        public TraitDefinition createTrait(ShapeId target, Node value) {
            ObjectNode members = Trait.coerceTraitValue(value, ShapeType.STRUCTURE).expectObjectNode();
            members.warnIfAdditionalProperties(TRAIT_DEFINITION_PROPERTY_NAMES);
            Builder builder = (Builder)TraitDefinition.builder().sourceLocation(value);
            members.getMember(TraitDefinition.SELECTOR_KEY).map(this::loadSelector).ifPresent(builder::selector);
            members.getBooleanMember(TraitDefinition.STRUCTURALLY_EXCLUSIVE_KEY).map(BooleanNode::getValue).ifPresent(builder::structurallyExclusive);
            members.getMember(TraitDefinition.CONFLICTS_KEY).ifPresent(values -> Node.loadArrayOfString(TraitDefinition.CONFLICTS_KEY, values).forEach(builder::addConflict));
            return builder.build();
        }

        private Selector loadSelector(Node node) {
            try {
                return Selector.parse(node.expectStringNode().getValue());
            }
            catch (SelectorSyntaxException e) {
                throw new SourceException(e.getMessage(), node, e);
            }
        }
    }

    public static final class Builder
    extends AbstractTraitBuilder<TraitDefinition, Builder> {
        private Selector selector = Selector.IDENTITY;
        private final List<ShapeId> conflicts = new ArrayList<ShapeId>();
        private boolean structurallyExclusive;

        private Builder() {
        }

        public Builder selector(Selector selector) {
            this.selector = selector;
            return this;
        }

        public Builder addConflict(String trait) {
            Objects.requireNonNull(trait);
            if (!trait.contains("#")) {
                trait = "smithy.api#" + trait;
            }
            return this.addConflict(ShapeId.from(trait));
        }

        public Builder addConflict(ShapeId id) {
            Objects.requireNonNull(id);
            this.conflicts.add(id);
            return this;
        }

        public Builder removeConflict(ToShapeId id) {
            this.conflicts.remove(id.toShapeId());
            return this;
        }

        public Builder structurallyExclusive(boolean structurallyExclusive) {
            this.structurallyExclusive = structurallyExclusive;
            return this;
        }

        public TraitDefinition build() {
            return new TraitDefinition(this);
        }
    }
}

