/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.traits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.node.ArrayNode;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.AbstractTrait;
import software.amazon.smithy.model.traits.AbstractTraitBuilder;
import software.amazon.smithy.model.traits.Protocol;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class ProtocolsTrait
extends AbstractTrait
implements ToSmithyBuilder<ProtocolsTrait> {
    public static final ShapeId ID = ShapeId.from("smithy.api#protocols");
    public static final String NONE_AUTH = "none";
    private static final List<String> PROPERTIES = ListUtils.of((Object[])new String[]{"name", "auth", "tags"});
    private final List<Protocol> protocols;

    private ProtocolsTrait(Builder builder) {
        super(ID, builder.sourceLocation);
        this.protocols = ListUtils.copyOf((Collection)builder.protocols);
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public List<String> getProtocolNames() {
        return this.protocols.stream().map(Protocol::getName).collect(Collectors.toList());
    }

    public Optional<Protocol> getProtocol(String name) {
        return this.protocols.stream().filter(p -> p.getName().equals(name)).findFirst();
    }

    public boolean hasProtocol(String name) {
        return this.getProtocol(name).isPresent();
    }

    public Set<String> getAllAuthSchemes() {
        return this.protocols.stream().flatMap(protocol -> protocol.getAuth().stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    protected Node createNode() {
        return this.protocols.stream().collect(ArrayNode.collect());
    }

    public Builder toBuilder() {
        Builder builder = ProtocolsTrait.builder();
        this.protocols.forEach(builder::addProtocol);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractTraitBuilder<ProtocolsTrait, Builder> {
        private List<Protocol> protocols = new ArrayList<Protocol>();

        private Builder() {
        }

        public ProtocolsTrait build() {
            return new ProtocolsTrait(this);
        }

        public Builder addProtocol(Protocol protocol) {
            this.protocols.add(Objects.requireNonNull(protocol));
            return this;
        }

        public Builder removeProtocol(String protocolName) {
            this.protocols.removeIf(p -> p.getName().equals(protocolName));
            return this;
        }

        public Builder clearProtocols() {
            this.protocols.clear();
            return this;
        }
    }

    public static final class Provider
    extends AbstractTrait.Provider {
        public Provider() {
            super(ID);
        }

        @Override
        public Trait createTrait(ShapeId target, Node value) {
            Builder builder = (Builder)ProtocolsTrait.builder().sourceLocation(value);
            for (ObjectNode protocol : value.expectArrayNode().getElementsAs(ObjectNode.class)) {
                protocol.warnIfAdditionalProperties(PROPERTIES);
                Protocol.Builder protocolBuilder = Protocol.builder();
                protocolBuilder.name(protocol.expectMember("name").expectStringNode().getValue());
                protocol.getMember("tags").map(Node::expectArrayNode).ifPresent(tagsNode -> tagsNode.getElements().stream().map(Node::expectStringNode).map(StringNode::getValue).forEach(protocolBuilder::addTag));
                protocol.getArrayMember("auth").ifPresent(auth -> Node.loadArrayOfString("auth", auth).forEach(protocolBuilder::addAuth));
                builder.addProtocol(protocolBuilder.build());
            }
            return builder.build();
        }
    }
}

