/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.shapes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.shapes.AbstractShapeBuilder;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class UnionShape
extends Shape
implements ToSmithyBuilder<UnionShape> {
    private final Map<String, MemberShape> members;

    private UnionShape(Builder builder) {
        super(builder, false);
        if (builder.members.isEmpty()) {
            throw new SourceException("union shapes require at least one member", builder.source);
        }
        builder.members.forEach((key, value) -> {
            ShapeId expected = this.getId().withMember((String)key);
            if (!value.getId().equals(expected)) {
                throw new IllegalArgumentException(String.format("Expected the `%s` member of `%s` to have an ID of `%s` but found `%s`", key, this.getId(), expected, value.getId()));
            }
        });
        this.members = new LinkedHashMap<String, MemberShape>(builder.members);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return ((Builder)UnionShape.builder().from(this)).members(this.getAllMembers().values());
    }

    @Override
    public <R> R accept(ShapeVisitor<R> cases) {
        return cases.unionShape(this);
    }

    @Override
    public Optional<UnionShape> asUnionShape() {
        return Optional.of(this);
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    public Optional<MemberShape> getMember(String tag) {
        return Optional.ofNullable(this.members.get(tag));
    }

    public List<String> getMemberNames() {
        return new ArrayList<String>(this.members.keySet());
    }

    public Map<String, MemberShape> getAllMembers() {
        return this.members;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other) && this.members.equals(((UnionShape)other).members);
    }

    public static final class Builder
    extends AbstractShapeBuilder<Builder, UnionShape> {
        private final Map<String, MemberShape> members = new LinkedHashMap<String, MemberShape>();

        public UnionShape build() {
            return new UnionShape(this);
        }

        @Override
        public ShapeType getShapeType() {
            return ShapeType.UNION;
        }

        public Builder members(Collection<MemberShape> members) {
            this.clearMembers();
            members.forEach(this::addMember);
            return this;
        }

        @Override
        public Builder addMember(MemberShape member) {
            this.members.put(member.getMemberName(), member);
            return this;
        }

        public Builder removeMember(String member) {
            this.members.remove(member);
            return this;
        }

        public Builder clearMembers() {
            this.members.clear();
            return this;
        }
    }
}

