/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.neighbor;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.smithy.model.neighbor.NeighborVisitor;
import software.amazon.smithy.model.neighbor.Relationship;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.utils.ListUtils;

@FunctionalInterface
public interface NeighborProvider {
    public List<Relationship> getNeighbors(Shape var1);

    public static NeighborProvider of(ShapeIndex index) {
        return new NeighborVisitor(index);
    }

    public static NeighborProvider precomputed(ShapeIndex index) {
        return NeighborProvider.precomputed(index, NeighborProvider.of(index));
    }

    public static NeighborProvider precomputed(ShapeIndex index, NeighborProvider provider) {
        HashMap relationships = new HashMap();
        index.shapes().forEach(shape -> relationships.put(shape.getId(), provider.getNeighbors((Shape)shape)));
        return shape -> relationships.getOrDefault(shape.getId(), ListUtils.of());
    }

    public static NeighborProvider bottomUp(ShapeIndex index) {
        return NeighborProvider.reverse(index, NeighborProvider.of(index));
    }

    public static NeighborProvider reverse(ShapeIndex index, NeighborProvider topDown) {
        Map targetedFrom = index.shapes().map(topDown::getNeighbors).flatMap(Collection::stream).distinct().collect(Collectors.groupingBy(Relationship::getNeighborShapeId, ListUtils.toUnmodifiableList()));
        return shape -> targetedFrom.getOrDefault(shape.getId(), ListUtils.of());
    }
}

