/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.model.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.function.Supplier;
import java.util.logging.Logger;
import software.amazon.smithy.model.loader.LoaderVisitor;
import software.amazon.smithy.model.loader.ModelDiscovery;
import software.amazon.smithy.model.loader.ModelImportException;
import software.amazon.smithy.model.loader.ModelLoader;
import software.amazon.smithy.utils.IoUtils;

final class JarModelLoader
implements ModelLoader {
    private static final Logger LOGGER = Logger.getLogger(JarModelLoader.class.getName());
    private final ModelLoader delegate;

    JarModelLoader(ModelLoader delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean load(String filename, Supplier<String> contentSupplier, LoaderVisitor visitor) {
        if (!filename.endsWith(".jar")) {
            return this.delegate.load(filename, contentSupplier, visitor);
        }
        URL manifestUrl = ModelDiscovery.createSmithyJarManifestUrl(filename);
        LOGGER.fine(() -> "Loading Smithy model imports from JAR: " + manifestUrl);
        for (URL model : ModelDiscovery.findModels(manifestUrl)) {
            try {
                InputStream is = model.openStream();
                try {
                    String contents = IoUtils.toUtf8String((InputStream)is);
                    this.delegate.load(model.toExternalForm(), () -> contents, visitor);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException e) {
                throw new ModelImportException(String.format("Error loading Smithy model from URL `%s`: %s", model, e.getMessage()), e);
            }
        }
        return true;
    }
}

