/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.EnumShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.NumberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeType;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.OptionalUtils;

public final class ShouldHaveUsedTimestampValidator
extends AbstractValidator {
    private static final List<Pattern> DEFAULT_PATTERNS = ListUtils.of((Object[])new Pattern[]{Pattern.compile("^.*[Tt]imestamp.*$"), Pattern.compile("^[Tt]ime([_A-Z].*)?$"), Pattern.compile("^[Dd]ate([_A-Z].*)?$"), Pattern.compile("^.*([a-z]T|_[Tt])ime$"), Pattern.compile("^.*([a-z]D|_[Dd])ate$"), Pattern.compile("^.*([a-z]A|_[Aa])t$"), Pattern.compile("^.*([a-z]O|_[Oo])n$"), Pattern.compile("^.*([a-z]S|_[Ss])ince$")});
    private final List<Pattern> patterns = new ArrayList<Pattern>(DEFAULT_PATTERNS);

    private ShouldHaveUsedTimestampValidator(Config config) {
        this.patterns.addAll(config.getAdditionalPatterns());
    }

    public List<ValidationEvent> validate(final Model model) {
        ShapeVisitor.Default<List<ValidationEvent>> visitor = new ShapeVisitor.Default<List<ValidationEvent>>(){

            protected List<ValidationEvent> getDefault(Shape shape) {
                if (shape.isStringShape() || shape instanceof NumberShape) {
                    return ShouldHaveUsedTimestampValidator.this.validateSimpleShape(shape);
                }
                return Collections.emptyList();
            }

            public List<ValidationEvent> structureShape(StructureShape shape) {
                return ShouldHaveUsedTimestampValidator.this.validateStructure(shape, model);
            }

            public List<ValidationEvent> unionShape(UnionShape shape) {
                return ShouldHaveUsedTimestampValidator.this.validateUnion(shape, model);
            }

            public List<ValidationEvent> enumShape(EnumShape shape) {
                return Collections.emptyList();
            }
        };
        return model.shapes().flatMap(arg_0 -> ShouldHaveUsedTimestampValidator.lambda$validate$0((ShapeVisitor)visitor, arg_0)).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateStructure(StructureShape structure, Model model) {
        return structure.getAllMembers().entrySet().stream().flatMap(entry -> this.validateTargetShape((String)entry.getKey(), (MemberShape)entry.getValue(), model)).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateUnion(UnionShape union, Model model) {
        return union.getAllMembers().entrySet().stream().flatMap(entry -> this.validateTargetShape((String)entry.getKey(), (MemberShape)entry.getValue(), model)).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateTargetShape(String name, MemberShape memberShape, Model model) {
        return OptionalUtils.stream(model.getShape(memberShape.getTarget()).flatMap(targetShape -> this.validateName(name, (Shape)targetShape, (Shape)memberShape, this.patterns, model)));
    }

    private List<ValidationEvent> validateSimpleShape(Shape shape) {
        String name = shape.getId().getName();
        return this.patterns.stream().filter(pattern -> pattern.matcher(name).matches()).map(matcher -> this.buildEvent(shape, name, shape.getType())).collect(Collectors.toList());
    }

    private Optional<ValidationEvent> validateName(String name, Shape targetShape, Shape context, List<Pattern> patterns, Model model) {
        ShapeType type = targetShape.getType();
        if (type == ShapeType.TIMESTAMP || type == ShapeType.ENUM) {
            return Optional.empty();
        }
        if ((type == ShapeType.STRUCTURE || type == ShapeType.LIST) && this.onlyContainsTimestamps(targetShape, model)) {
            return Optional.empty();
        }
        return patterns.stream().filter(pattern -> pattern.matcher(name).matches()).map(matcher -> this.buildEvent(context, name, type)).findAny();
    }

    private boolean onlyContainsTimestamps(Shape shape, Model model) {
        return shape.getAllMembers().values().stream().map(memberShape -> model.getShape(memberShape.getTarget())).filter(Optional::isPresent).map(Optional::get).allMatch(Shape::isTimestampShape);
    }

    private ValidationEvent buildEvent(Shape context, String name, ShapeType type) {
        return this.danger(context, context.isMemberShape() ? String.format("Member `%s` is named like a timestamp but references a `%s` shape", name, type) : String.format("Shape `%s` is named like a timestamp but is a `%s` shape.", name, type));
    }

    private static /* synthetic */ Stream lambda$validate$0(ShapeVisitor visitor, Shape shape) {
        return ((List)shape.accept(visitor)).stream();
    }

    public static final class Config {
        private List<Pattern> additionalPatterns = new ArrayList<Pattern>();

        public void setAdditionalPatterns(List<Pattern> additionalPatterns) {
            this.additionalPatterns = additionalPatterns;
        }

        public List<Pattern> getAdditionalPatterns() {
            return this.additionalPatterns;
        }
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(ShouldHaveUsedTimestampValidator.class, configuration -> {
                Config config = (Config)new NodeMapper().deserialize((Node)configuration, Config.class);
                return new ShouldHaveUsedTimestampValidator(config);
            });
        }
    }
}

