/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import software.amazon.smithy.linters.WildcardMatcher;
import software.amazon.smithy.linters.WordBoundaryMatcher;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;

public final class ReservedWordsValidator
extends AbstractValidator {
    private final Config config;

    private ReservedWordsValidator(Config config) {
        this.config = config;
    }

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (ReservedWords reserved : this.config.getReserved()) {
            reserved.validate(model, events);
        }
        return events;
    }

    public static final class Config {
        private List<ReservedWords> reserved = Collections.emptyList();

        public List<ReservedWords> getReserved() {
            return this.reserved;
        }

        public void setReserved(List<ReservedWords> reserved) {
            this.reserved = reserved;
        }
    }

    public static final class ReservedWords {
        private Selector selector = Selector.IDENTITY;
        private String reason = "";
        private final WildcardMatcher wildcardMatcher = new WildcardMatcher();
        private final WordBoundaryMatcher wordMatcher = new WordBoundaryMatcher();

        public void setWords(List<String> words) {
            words.forEach(this.wildcardMatcher::addSearch);
        }

        public void setTerms(List<String> terms) {
            terms.forEach(this.wordMatcher::addSearch);
        }

        public void setSelector(Selector selector) {
            this.selector = selector;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        private void validate(Model model, List<ValidationEvent> events) {
            for (Shape shape : this.selector.select(model)) {
                this.validateShape(shape).ifPresent(events::add);
            }
        }

        private Optional<ValidationEvent> validateShape(Shape shape) {
            String name = shape.asMemberShape().map(MemberShape::getMemberName).orElseGet(() -> shape.getId().getName());
            return this.isReservedWord(name) ? Optional.of(this.emit(shape, name, this.reason)) : Optional.empty();
        }

        private boolean isReservedWord(String word) {
            return this.wildcardMatcher.test(word) || this.wordMatcher.test(word);
        }

        private ValidationEvent emit(Shape shape, String word, String reason) {
            return ValidationEvent.builder().severity(Severity.DANGER).id(ValidatorService.determineValidatorName(ReservedWordsValidator.class)).shape(shape).message(String.format("The word `%s` is reserved. %s", word, reason)).build();
        }
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(ReservedWordsValidator.class, node -> {
                NodeMapper mapper = new NodeMapper();
                return new ReservedWordsValidator((Config)mapper.deserialize((Node)node, Config.class));
            });
        }
    }
}

