/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceLocation;
import software.amazon.smithy.model.knowledge.TextIndex;
import software.amazon.smithy.model.knowledge.TextInstance;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.ListUtils;
import software.amazon.smithy.utils.MapUtils;
import software.amazon.smithy.utils.StringUtils;

public final class NoninclusiveTermsValidator
extends AbstractValidator {
    static final Map<String, List<String>> BUILT_IN_NONINCLUSIVE_TERMS = MapUtils.of((Object)"master", (Object)ListUtils.of((Object[])new String[]{"primary", "parent", "main"}), (Object)"slave", (Object)ListUtils.of((Object[])new String[]{"secondary", "replica", "clone", "child"}), (Object)"blacklist", (Object)ListUtils.of((Object)"denyList"), (Object)"whitelist", (Object)ListUtils.of((Object)"allowList"));
    private static final String TRAIT = "Trait";
    private static final String SHAPE = "Shape";
    private static final String NAMESPACE = "Namespace";
    private final Map<String, List<String>> termsMap;

    private NoninclusiveTermsValidator(Config config) {
        HashMap<String, List<String>> termsMapInit = new HashMap<String, List<String>>(BUILT_IN_NONINCLUSIVE_TERMS);
        if (!config.getExcludeDefaults()) {
            termsMapInit.putAll(config.getTerms());
            this.termsMap = Collections.unmodifiableMap(termsMapInit);
        } else {
            if (config.getTerms().isEmpty()) {
                throw new IllegalArgumentException("Cannot set 'excludeDefaults' to true and leave 'terms' empty or unspecified.");
            }
            this.termsMap = Collections.unmodifiableMap(config.getTerms());
        }
    }

    public List<ValidationEvent> validate(Model model) {
        TextIndex textIndex = TextIndex.of((Model)model);
        ArrayList<ValidationEvent> validationEvents = new ArrayList<ValidationEvent>();
        for (TextInstance text : textIndex.getTextInstances()) {
            validationEvents.addAll(this.getValidationEvents(text));
        }
        return validationEvents;
    }

    private Collection<ValidationEvent> getValidationEvents(TextInstance instance) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        for (Map.Entry<String, List<String>> termEntry : this.termsMap.entrySet()) {
            String termLower = termEntry.getKey().toLowerCase();
            int startIndex = instance.getText().toLowerCase().indexOf(termLower);
            if (startIndex == -1) continue;
            String matchedText = instance.getText().substring(startIndex, startIndex + termLower.length());
            events.add(this.constructValidationEvent(instance, termEntry.getValue(), matchedText));
        }
        return events;
    }

    private ValidationEvent constructValidationEvent(TextInstance instance, List<String> replacements, String matchedText) {
        String replacementAddendum = NoninclusiveTermsValidator.getReplacementAddendum(matchedText, replacements);
        switch (instance.getLocationType()) {
            case NAMESPACE: {
                return ValidationEvent.builder().severity(Severity.WARNING).sourceLocation((FromSourceLocation)SourceLocation.none()).id(this.getName() + "." + NAMESPACE + "." + instance.getText() + "." + matchedText.toLowerCase(Locale.US)).message(String.format("%s namespace uses a non-inclusive term `%s`.%s", instance.getText(), matchedText, replacementAddendum)).build();
            }
            case APPLIED_TRAIT: {
                ValidationEvent validationEvent = this.warning(instance.getShape(), (FromSourceLocation)instance.getTrait().getSourceLocation(), "");
                String idiomaticTraitName = Trait.getIdiomaticTraitName((ToShapeId)instance.getTrait());
                if (instance.getTraitPropertyPath().isEmpty()) {
                    return validationEvent.toBuilder().message(String.format("'%s' trait has a value that contains a non-inclusive term `%s`.%s", idiomaticTraitName, matchedText, replacementAddendum)).id(this.getName() + "." + TRAIT + "." + matchedText.toLowerCase(Locale.US) + "." + idiomaticTraitName).build();
                }
                String valuePropertyPathFormatted = NoninclusiveTermsValidator.formatPropertyPath(instance.getTraitPropertyPath());
                return validationEvent.toBuilder().message(String.format("'%s' trait value at path {%s} contains a non-inclusive term `%s`.%s", idiomaticTraitName, valuePropertyPathFormatted, matchedText, replacementAddendum)).id(this.getName() + "." + TRAIT + "." + matchedText.toLowerCase(Locale.US) + "." + idiomaticTraitName + "." + valuePropertyPathFormatted).build();
            }
        }
        return this.warning(instance.getShape(), (FromSourceLocation)instance.getShape().getSourceLocation(), String.format("%s shape uses a non-inclusive term `%s`.%s", StringUtils.capitalize((String)instance.getShape().getType().toString()), matchedText, replacementAddendum), SHAPE, matchedText.toLowerCase(Locale.US));
    }

    private static String getReplacementAddendum(String matchedText, List<String> replacements) {
        List caseCorrectedEntryValue = replacements.stream().map(replacement -> Character.isUpperCase(matchedText.charAt(0)) ? StringUtils.capitalize((String)replacement) : StringUtils.uncapitalize((String)replacement)).collect(Collectors.toList());
        String replacementAddendum = !replacements.isEmpty() ? String.format(" Consider using one of the following terms instead: %s", ValidationUtils.tickedList(caseCorrectedEntryValue)) : "";
        return replacementAddendum;
    }

    private static String formatPropertyPath(List<String> traitPropertyPath) {
        return String.join((CharSequence)"/", traitPropertyPath);
    }

    public static final class Config {
        private Map<String, List<String>> terms = MapUtils.of();
        private boolean excludeDefaults;

        public Map<String, List<String>> getTerms() {
            return this.terms;
        }

        public void setTerms(Map<String, List<String>> terms) {
            this.terms = terms;
        }

        public boolean getExcludeDefaults() {
            return this.excludeDefaults;
        }

        public void setExcludeDefaults(boolean excludeDefaults) {
            this.excludeDefaults = excludeDefaults;
        }
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(NoninclusiveTermsValidator.class, node -> {
                NodeMapper mapper = new NodeMapper();
                return new NoninclusiveTermsValidator((Config)mapper.deserialize((Node)node, Config.class));
            });
        }
    }
}

