/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;

public final class RepeatedShapeNameValidator
extends AbstractValidator {
    private final Config config;

    private RepeatedShapeNameValidator(Config config) {
        this.config = config;
    }

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        model.shapes(StructureShape.class).forEach(shape -> events.addAll(this.validateNames(model, (Shape)shape, shape.getMemberNames())));
        model.shapes(UnionShape.class).forEach(shape -> events.addAll(this.validateNames(model, (Shape)shape, shape.getMemberNames())));
        return events;
    }

    private List<ValidationEvent> validateNames(Model model, Shape shape, Collection<String> memberNames) {
        String shapeName = shape.getId().getName();
        String lowerCaseShapeName = shapeName.toLowerCase(Locale.US);
        return memberNames.stream().filter(memberName -> this.nameConflicts(lowerCaseShapeName, (String)memberName)).map(memberName -> this.repeatedMemberName(model, shape, shapeName, (String)memberName)).collect(Collectors.toList());
    }

    private boolean nameConflicts(String lowerCaseShapeName, String memberName) {
        String lowerCaseMemberName = memberName.toLowerCase(Locale.US);
        if (this.config.getExactMatch()) {
            return lowerCaseMemberName.equals(lowerCaseShapeName);
        }
        return lowerCaseMemberName.startsWith(lowerCaseShapeName);
    }

    private ValidationEvent repeatedMemberName(Model model, Shape shape, String shapeName, String memberName) {
        Shape member = model.expectShape(shape.getId().withMember(memberName));
        if (this.config.getExactMatch()) {
            return this.warning(member, String.format("The `%s` %s shape repeats its name in the member `%s`; %2$s member names should not be equal to the %2$s name.", shapeName, shape.getType(), memberName));
        }
        return this.warning(member, String.format("The `%s` %s shape repeats its name in the member `%s`; %2$s member names should not be prefixed with the %2$s name.", shapeName, shape.getType(), memberName));
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(RepeatedShapeNameValidator.class, node -> {
                Config config = (Config)new NodeMapper().deserialize((Node)node, Config.class);
                return new RepeatedShapeNameValidator(config);
            });
        }
    }

    public static final class Config {
        private boolean exactMatch = false;

        public boolean getExactMatch() {
            return this.exactMatch;
        }

        public void setExactMatch(boolean exactMatch) {
            this.exactMatch = exactMatch;
        }
    }
}

