/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.AuthDefinitionTrait;
import software.amazon.smithy.model.traits.ProtocolDefinitionTrait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.FunctionalUtils;

public final class CamelCaseValidator
extends AbstractValidator {
    private static final Pattern UPPER_CAMEL_CASE = Pattern.compile("^[A-Z]+[A-Za-z0-9]*$");
    private static final Pattern LOWER_CAMEL_CASE = Pattern.compile("^[a-z]+[A-Za-z0-9]*$");
    private final Config config;

    private CamelCaseValidator(Config config) {
        this.config = config;
    }

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        model.shapes().filter(FunctionalUtils.not(Shape::isMemberShape)).filter(shape -> !shape.hasTrait(TraitDefinition.class)).filter(shape -> !MemberNameHandling.UPPER.getRegex().matcher(shape.getId().getName()).find()).map(shape -> this.danger((Shape)shape, String.format("%s shape name, `%s`, is not %s camel case", new Object[]{shape.getType(), shape.getId().getName(), MemberNameHandling.UPPER}))).forEach(events::add);
        model.shapes().filter(shape -> shape.hasTrait(TraitDefinition.class)).filter(shape -> !shape.hasTrait(AuthDefinitionTrait.class)).filter(shape -> !shape.hasTrait(ProtocolDefinitionTrait.class)).filter(shape -> !MemberNameHandling.LOWER.getRegex().matcher(shape.getId().getName()).find()).map(shape -> this.danger((Shape)shape, String.format("%s trait definition, `%s`, is not lower camel case", shape.getType(), shape.getId().getName()))).forEach(events::add);
        HashSet<MemberShape> seenShapes = new HashSet<MemberShape>();
        for (ServiceShape serviceShape : model.getServiceShapes()) {
            HashSet serviceClosure = new HashSet();
            Walker walker = new Walker(model);
            walker.iterateShapes((Shape)serviceShape).forEachRemaining(serviceClosure::add);
            List<MemberShape> memberShapes = serviceClosure.stream().filter(Shape::isMemberShape).map(shape -> (MemberShape)shape).collect(Collectors.toList());
            events.addAll(this.validateCamelCasing(memberShapes, serviceShape.getId().getName()));
            seenShapes.addAll(memberShapes);
        }
        Map<String, List<MemberShape>> memberShapesByNamespace = model.toSet(MemberShape.class).stream().filter(memberShape -> !seenShapes.contains(memberShape)).collect(Collectors.groupingBy(memberShape -> memberShape.getContainer().getNamespace()));
        for (Map.Entry<String, List<MemberShape>> memberShapeGrouping : memberShapesByNamespace.entrySet()) {
            events.addAll(this.validateCamelCasing(memberShapeGrouping.getValue(), memberShapeGrouping.getKey() + " namespace"));
        }
        return events;
    }

    private List<ValidationEvent> validateCamelCasing(List<MemberShape> memberShapes, String scope) {
        int upperCamelMemberNamesCount = 0;
        int lowerCamelMemberNamesCount = 0;
        HashSet<MemberShape> nonUpperCamelMemberShapes = new HashSet<MemberShape>();
        HashSet<MemberShape> nonLowerCamelMemberShapes = new HashSet<MemberShape>();
        for (MemberShape memberShape : memberShapes) {
            if (MemberNameHandling.UPPER.getRegex().matcher(memberShape.getMemberName()).find()) {
                ++upperCamelMemberNamesCount;
            } else {
                nonUpperCamelMemberShapes.add(memberShape);
            }
            if (MemberNameHandling.LOWER.getRegex().matcher(memberShape.getMemberName()).find()) {
                ++lowerCamelMemberNamesCount;
                continue;
            }
            nonLowerCamelMemberShapes.add(memberShape);
        }
        HashSet violatingMemberShapes = new HashSet();
        String memberNameHandling = this.config.getMemberNames().toString();
        if (MemberNameHandling.AUTO.equals((Object)this.config.getMemberNames())) {
            if (upperCamelMemberNamesCount > lowerCamelMemberNamesCount) {
                violatingMemberShapes = nonUpperCamelMemberShapes;
                memberNameHandling = MemberNameHandling.UPPER.toString();
            } else {
                violatingMemberShapes = nonLowerCamelMemberShapes;
                memberNameHandling = MemberNameHandling.LOWER.toString();
            }
        } else if (MemberNameHandling.UPPER.equals((Object)this.config.getMemberNames())) {
            violatingMemberShapes = nonUpperCamelMemberShapes;
        } else if (MemberNameHandling.LOWER.equals((Object)this.config.getMemberNames())) {
            violatingMemberShapes = nonLowerCamelMemberShapes;
        }
        String finalMemberNameHandling = memberNameHandling;
        return violatingMemberShapes.stream().map(shape -> this.danger((Shape)shape, String.format("Member shape member name, `%s`, is not %s camel case; members in the %s must all use %s camel case.", shape.getMemberName(), finalMemberNameHandling, scope, finalMemberNameHandling))).collect(Collectors.toList());
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(CamelCaseValidator.class, configuration -> {
                NodeMapper mapper = new NodeMapper();
                return new CamelCaseValidator((Config)mapper.deserialize((Node)configuration, Config.class));
            });
        }
    }

    public static enum MemberNameHandling {
        UPPER{

            @Override
            Pattern getRegex() {
                return UPPER_CAMEL_CASE;
            }

            public String toString() {
                return "upper";
            }
        }
        ,
        LOWER{

            @Override
            Pattern getRegex() {
                return LOWER_CAMEL_CASE;
            }

            public String toString() {
                return "lower";
            }
        }
        ,
        AUTO{

            @Override
            Pattern getRegex() {
                return null;
            }

            public String toString() {
                return "auto";
            }
        };


        abstract Pattern getRegex();
    }

    public static final class Config {
        private MemberNameHandling memberNames = MemberNameHandling.AUTO;

        public MemberNameHandling getMemberNames() {
            return this.memberNames;
        }

        public void setMemberNames(MemberNameHandling memberNames) {
            this.memberNames = memberNames;
        }
    }
}

