/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.AuthDefinitionTrait;
import software.amazon.smithy.model.traits.ProtocolDefinitionTrait;
import software.amazon.smithy.model.traits.TraitDefinition;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.FunctionalUtils;

public final class CamelCaseValidator
extends AbstractValidator {
    private static final Pattern UPPER_CAMEL_CASE = Pattern.compile("^[A-Z]+[A-Za-z0-9]*$");
    private static final Pattern LOWER_CAMEL_CASE = Pattern.compile("^[a-z]+[A-Za-z0-9]*$");
    private final Config config;

    private CamelCaseValidator(Config config) {
        this.config = config;
    }

    public List<ValidationEvent> validate(Model model) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        model.shapes().filter(FunctionalUtils.not(Shape::isMemberShape)).filter(shape -> !shape.hasTrait(TraitDefinition.class)).filter(shape -> !MemberNameHandling.UPPER.getRegex().matcher(shape.getId().getName()).find()).map(shape -> this.danger((Shape)shape, String.format("%s shape name, `%s`, is not %s camel case", new Object[]{shape.getType(), shape.getId().getName(), MemberNameHandling.UPPER}))).forEach(events::add);
        model.shapes().filter(shape -> shape.hasTrait(TraitDefinition.class)).filter(shape -> !shape.hasTrait(AuthDefinitionTrait.class)).filter(shape -> !shape.hasTrait(ProtocolDefinitionTrait.class)).filter(shape -> !MemberNameHandling.LOWER.getRegex().matcher(shape.getId().getName()).find()).map(shape -> this.danger((Shape)shape, String.format("%s trait definition, `%s`, is not lower camel case", shape.getType(), shape.getId().getName()))).forEach(events::add);
        Pattern isValidMemberName = this.config.getMemberNames().getRegex();
        model.shapes(MemberShape.class).filter(shape -> !isValidMemberName.matcher(shape.getMemberName()).find()).map(shape -> this.danger((Shape)shape, String.format("Member shape member name, `%s`, is not %s camel case", new Object[]{shape.getMemberName(), this.config.getMemberNames()}))).forEach(events::add);
        return events;
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(CamelCaseValidator.class, configuration -> {
                NodeMapper mapper = new NodeMapper();
                return new CamelCaseValidator((Config)mapper.deserialize((Node)configuration, Config.class));
            });
        }
    }

    public static enum MemberNameHandling {
        UPPER{

            @Override
            Pattern getRegex() {
                return UPPER_CAMEL_CASE;
            }

            public String toString() {
                return "upper";
            }
        }
        ,
        LOWER{

            @Override
            Pattern getRegex() {
                return LOWER_CAMEL_CASE;
            }

            public String toString() {
                return "lower";
            }
        };


        abstract Pattern getRegex();
    }

    public static final class Config {
        private MemberNameHandling memberNames = MemberNameHandling.LOWER;

        public MemberNameHandling getMemberNames() {
            return this.memberNames;
        }

        public void setMemberNames(MemberNameHandling memberNames) {
            this.memberNames = memberNames;
        }
    }
}

