/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.OptionalUtils;

public final class ReservedWordsValidator
extends AbstractValidator {
    private static final Pattern CONTAINS_INNER_WILDCARD = Pattern.compile("^.+\\*.+$");
    private final Config config;

    private ReservedWordsValidator(Config config) {
        this.config = config;
        if (config.getReserved().isEmpty()) {
            throw new IllegalArgumentException("Missing `reserved` words");
        }
    }

    public List<ValidationEvent> validate(Model model) {
        return this.config.getReserved().stream().flatMap(reservation -> ((ReservedWords)reservation).validate(model)).collect(Collectors.toList());
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(ReservedWordsValidator.class, node -> {
                NodeMapper mapper = new NodeMapper();
                return new ReservedWordsValidator((Config)mapper.deserialize((Node)node, Config.class));
            });
        }
    }

    public static final class ReservedWords {
        private List<String> words = Collections.emptyList();
        private Selector selector = Selector.IDENTITY;
        private String reason = "";

        public void setWords(List<String> words) {
            this.words = new ArrayList<String>(words.size());
            for (String word : words) {
                if (word.equals("*")) {
                    throw new IllegalArgumentException("Reservations cannot be made against '*'");
                }
                if (CONTAINS_INNER_WILDCARD.matcher(word).find()) {
                    throw new IllegalArgumentException("Only preceding and trailing wildcards ('*') are supported.");
                }
                this.words.add(word.toLowerCase(Locale.ENGLISH));
            }
        }

        public void setSelector(Selector selector) {
            this.selector = selector;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }

        private Stream<ValidationEvent> validate(Model model) {
            return this.selector.select(model).stream().flatMap(shape -> OptionalUtils.stream(this.validateShape((Shape)shape)));
        }

        private Optional<ValidationEvent> validateShape(Shape shape) {
            String name = shape.asMemberShape().map(MemberShape::getMemberName).orElseGet(() -> shape.getId().getName());
            return this.isReservedWord(name) ? Optional.of(this.emit(shape, name, this.reason)) : Optional.empty();
        }

        private boolean isReservedWord(String word) {
            String compare = word.toLowerCase(Locale.US);
            return this.words.stream().anyMatch(reservation -> {
                if (reservation.startsWith("*")) {
                    if (reservation.endsWith("*")) {
                        return compare.contains(reservation.substring(1, reservation.lastIndexOf("*")));
                    }
                    return compare.endsWith(reservation.substring(1));
                }
                if (reservation.endsWith("*")) {
                    return compare.startsWith(reservation.substring(0, reservation.lastIndexOf("*")));
                }
                return compare.equals(reservation);
            });
        }

        private ValidationEvent emit(Shape shape, String word, String reason) {
            return ValidationEvent.builder().severity(Severity.DANGER).eventId(ValidatorService.determineValidatorName(ReservedWordsValidator.class)).shape(shape).message(String.format("The word `%s` is reserved. %s", word, reason)).build();
        }
    }

    public static final class Config {
        private List<ReservedWords> reserved = Collections.emptyList();

        public List<ReservedWords> getReserved() {
            return this.reserved;
        }

        public void setReserved(List<ReservedWords> reserved) {
            this.reserved = reserved;
        }
    }
}

