/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidationUtils;
import software.amazon.smithy.model.validation.ValidatorService;

public final class AbbreviationNameValidator
extends AbstractValidator {
    private List<String> allowedAbbreviations;

    private AbbreviationNameValidator(List<String> allowedAbbreviations) {
        this.allowedAbbreviations = allowedAbbreviations;
    }

    public List<ValidationEvent> validate(Model model) {
        return model.shapes().flatMap(this::validateShapeName).collect(Collectors.toList());
    }

    private Stream<ValidationEvent> validateShapeName(Shape shape) {
        String descriptor = shape.isMemberShape() ? "member" : "shape";
        String name = shape.asMemberShape().map(MemberShape::getMemberName).orElseGet(() -> shape.getId().getName());
        String recommendedName = this.createRecommendedName(name);
        if (recommendedName.equals(name)) {
            return Stream.empty();
        }
        return Stream.of(this.danger(shape, String.format("%s name, `%s`, contains invalid abbreviations. Change this %s name to `%s`", descriptor, name, descriptor, recommendedName)));
    }

    private String createRecommendedName(String name) {
        StringBuilder recommendedWordBuilder = new StringBuilder();
        for (String word : ValidationUtils.splitCamelCaseWord((String)name)) {
            if (this.allowedAbbreviations.contains(word)) {
                recommendedWordBuilder.append(word);
                continue;
            }
            if (!this.isInvalidWord(word)) {
                recommendedWordBuilder.append(word);
                continue;
            }
            recommendedWordBuilder.append(word.substring(0, 1).toUpperCase(Locale.US));
            recommendedWordBuilder.append(word.substring(1).toLowerCase(Locale.US));
        }
        return recommendedWordBuilder.toString();
    }

    private boolean isInvalidWord(String word) {
        return word.chars().filter(c -> c >= 65 && c <= 90).count() > 1L;
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(AbbreviationNameValidator.class, configuration -> new AbbreviationNameValidator(configuration.getArrayMember("allowedAbbreviations").map(arr -> arr.getElementsAs(StringNode::getValue)).orElseGet(Collections::emptyList)));
        }
    }
}

