/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.linters;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.amazon.smithy.model.FromSourceLocation;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.SourceException;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.node.StringNode;
import software.amazon.smithy.model.selector.Selector;
import software.amazon.smithy.model.selector.SelectorSyntaxException;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.validation.AbstractValidator;
import software.amazon.smithy.model.validation.Severity;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.model.validation.ValidatorService;
import software.amazon.smithy.utils.ListUtils;

public final class EmitNoneSelectorValidator
extends AbstractValidator {
    private final Selector selector;

    private EmitNoneSelectorValidator(Selector selector) {
        this.selector = selector;
    }

    private static Selector parse(StringNode expression) {
        try {
            return Selector.parse((String)expression.getValue().trim());
        }
        catch (SelectorSyntaxException e) {
            throw new SourceException("Invalid selector expression: " + e.getMessage(), (FromSourceLocation)expression, (Throwable)e);
        }
    }

    public List<ValidationEvent> validate(Model model) {
        Set shapes = this.selector.select(model.getShapeIndex()).stream().filter(shape -> !Prelude.isPreludeShape((ToShapeId)shape.getId())).collect(Collectors.toSet());
        if (shapes.isEmpty()) {
            return ListUtils.of((Object)ValidationEvent.builder().eventId(this.getName()).severity(Severity.DANGER).message("Expected at least one shape to match selector: " + this.selector).build());
        }
        return ListUtils.of();
    }

    public static final class Provider
    extends ValidatorService.Provider {
        public Provider() {
            super(EmitNoneSelectorValidator.class, configuration -> {
                Selector selector = EmitNoneSelectorValidator.parse(configuration.expectMember("selector").expectStringNode());
                return new EmitNoneSelectorValidator(selector);
            });
        }
    }
}

