/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.NodeMapper;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.node.ToNode;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeId;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.traits.TimestampFormatTrait;

public class JsonSchemaConfig {
    private boolean alphanumericOnlyRefs;
    private boolean useJsonName;
    private TimestampFormatTrait.Format defaultTimestampFormat = TimestampFormatTrait.Format.DATE_TIME;
    private UnionStrategy unionStrategy = UnionStrategy.ONE_OF;
    private MapStrategy mapStrategy = MapStrategy.PROPERTY_NAMES;
    private String definitionPointer = "#/definitions";
    private ObjectNode schemaDocumentExtensions = Node.objectNode();
    private ObjectNode extensions = Node.objectNode();
    private Set<String> disableFeatures = new HashSet<String>();
    private final ConcurrentHashMap<Class, Object> extensionCache = new ConcurrentHashMap();
    private final NodeMapper nodeMapper = new NodeMapper();
    private ShapeId service;
    private boolean supportNonNumericFloats = false;

    public JsonSchemaConfig() {
        this.nodeMapper.setWhenMissingSetter(NodeMapper.WhenMissing.INGORE);
    }

    public boolean getAlphanumericOnlyRefs() {
        return this.alphanumericOnlyRefs;
    }

    public void setAlphanumericOnlyRefs(boolean alphanumericOnlyRefs) {
        this.alphanumericOnlyRefs = alphanumericOnlyRefs;
    }

    public boolean getUseJsonName() {
        return this.useJsonName;
    }

    public void setUseJsonName(boolean useJsonName) {
        this.useJsonName = useJsonName;
    }

    public TimestampFormatTrait.Format getDefaultTimestampFormat() {
        return this.defaultTimestampFormat;
    }

    public void setDefaultTimestampFormat(TimestampFormatTrait.Format defaultTimestampFormat) {
        this.defaultTimestampFormat = defaultTimestampFormat;
    }

    public UnionStrategy getUnionStrategy() {
        return this.unionStrategy;
    }

    public void setUnionStrategy(UnionStrategy unionStrategy) {
        this.unionStrategy = unionStrategy;
    }

    public MapStrategy getMapStrategy() {
        return this.mapStrategy;
    }

    public void setMapStrategy(MapStrategy mapStrategy) {
        this.mapStrategy = mapStrategy;
    }

    public String getDefinitionPointer() {
        return this.definitionPointer;
    }

    public void setDefinitionPointer(String definitionPointer) {
        this.definitionPointer = Objects.requireNonNull(definitionPointer);
    }

    public ObjectNode getSchemaDocumentExtensions() {
        return this.schemaDocumentExtensions;
    }

    public void setSchemaDocumentExtensions(ObjectNode schemaDocumentExtensions) {
        this.schemaDocumentExtensions = Objects.requireNonNull(schemaDocumentExtensions);
    }

    public Set<String> getDisableFeatures() {
        return this.disableFeatures;
    }

    public void setDisableFeatures(Set<String> disableFeatures) {
        this.disableFeatures = disableFeatures;
    }

    public ObjectNode getExtensions() {
        return this.extensions;
    }

    public <T> T getExtensions(Class<T> as) {
        return (T)this.extensionCache.computeIfAbsent(as, t -> this.nodeMapper.deserialize((Node)this.extensions, t));
    }

    public void setExtensions(ObjectNode extensions) {
        this.extensions = Objects.requireNonNull(extensions);
        this.extensionCache.clear();
    }

    public void putExtensions(Object extensionContainer) {
        ObjectNode serialized = this.nodeMapper.serialize(extensionContainer).expectObjectNode();
        this.setExtensions(this.extensions.merge(serialized));
    }

    public void putExtension(String key, Node value) {
        this.setExtensions(this.extensions.withMember(key, (ToNode)value));
    }

    public void putExtension(String key, boolean value) {
        this.putExtension(key, (Node)Node.from((boolean)value));
    }

    public void putExtension(String key, String value) {
        this.putExtension(key, (Node)Node.from((String)value));
    }

    public ShapeId getService() {
        return this.service;
    }

    public void setService(ShapeId service) {
        this.service = service;
    }

    public Optional<String> detectJsonTimestampFormat(Shape shape) {
        if (shape.isTimestampShape() || shape.hasTrait(TimestampFormatTrait.class)) {
            return Optional.of(shape.getTrait(TimestampFormatTrait.class).map(StringTrait::getValue).orElseGet(() -> this.getDefaultTimestampFormat().toString()));
        }
        return Optional.empty();
    }

    public boolean getSupportNonNumericFloats() {
        return this.supportNonNumericFloats;
    }

    public void setSupportNonNumericFloats(boolean supportNonNumericFloats) {
        this.supportNonNumericFloats = supportNonNumericFloats;
    }

    public static enum MapStrategy {
        PROPERTY_NAMES("propertyNames"),
        PATTERN_PROPERTIES("patternProperties");

        private String stringValue;

        private MapStrategy(String stringValue) {
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static enum UnionStrategy {
        ONE_OF("oneOf"),
        OBJECT("object"),
        STRUCTURE("structure");

        private String stringValue;

        private UnionStrategy(String stringValue) {
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }
}

