/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import software.amazon.smithy.jsonschema.JsonSchemaConfig;
import software.amazon.smithy.jsonschema.JsonSchemaConverter;
import software.amazon.smithy.jsonschema.JsonSchemaMapper;
import software.amazon.smithy.jsonschema.JsonSchemaMapperContext;
import software.amazon.smithy.jsonschema.JsonSchemaVersion;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.jsonschema.SmithyJsonSchemaException;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.BigDecimalShape;
import software.amazon.smithy.model.shapes.BigIntegerShape;
import software.amazon.smithy.model.shapes.BlobShape;
import software.amazon.smithy.model.shapes.BooleanShape;
import software.amazon.smithy.model.shapes.ByteShape;
import software.amazon.smithy.model.shapes.DocumentShape;
import software.amazon.smithy.model.shapes.DoubleShape;
import software.amazon.smithy.model.shapes.FloatShape;
import software.amazon.smithy.model.shapes.IntEnumShape;
import software.amazon.smithy.model.shapes.IntegerShape;
import software.amazon.smithy.model.shapes.ListShape;
import software.amazon.smithy.model.shapes.LongShape;
import software.amazon.smithy.model.shapes.MapShape;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ShortShape;
import software.amazon.smithy.model.shapes.StringShape;
import software.amazon.smithy.model.shapes.StructureShape;
import software.amazon.smithy.model.shapes.TimestampShape;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.shapes.UnionShape;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.DeprecatedTrait;
import software.amazon.smithy.model.traits.DocumentationTrait;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.traits.LengthTrait;
import software.amazon.smithy.model.traits.MediaTypeTrait;
import software.amazon.smithy.model.traits.PatternTrait;
import software.amazon.smithy.model.traits.RangeTrait;
import software.amazon.smithy.model.traits.StringTrait;
import software.amazon.smithy.model.traits.TitleTrait;
import software.amazon.smithy.model.traits.UniqueItemsTrait;
import software.amazon.smithy.utils.ListUtils;

final class JsonSchemaShapeVisitor
extends ShapeVisitor.Default<Schema> {
    private static final Set<String> NON_NUMERIC_FLOAT_VALUES = Node.NonNumericFloat.stringRepresentations();
    private final Model model;
    private final JsonSchemaConverter converter;
    private final List<JsonSchemaMapper> mappers;

    JsonSchemaShapeVisitor(Model model, JsonSchemaConverter converter, List<JsonSchemaMapper> mappers) {
        this.model = model;
        this.converter = converter;
        this.mappers = mappers;
    }

    public Schema getDefault(Shape shape) {
        throw new SmithyJsonSchemaException("Unable to convert " + shape + " to JSON Schema");
    }

    public Schema documentShape(DocumentShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, null));
    }

    public Schema blobShape(BlobShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "string"));
    }

    public Schema booleanShape(BooleanShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "boolean"));
    }

    public Schema listShape(ListShape shape) {
        Schema.Builder builder = this.createBuilder((Shape)shape, "array").items(this.createRef(shape.getMember()));
        if (shape.hasTrait(UniqueItemsTrait.class)) {
            builder.uniqueItems(true);
        }
        return this.buildSchema((Shape)shape, builder);
    }

    private Schema createRef(MemberShape member) {
        if (this.converter.isInlined((Shape)member)) {
            return (Schema)member.accept((ShapeVisitor)this);
        }
        Schema.Builder refBuilder = Schema.builder().ref(this.converter.toPointer((ToShapeId)member.getTarget()));
        if (member.hasTrait(DeprecatedTrait.class) && this.getJsonSchemaVersion() != JsonSchemaVersion.DRAFT07) {
            refBuilder.deprecated(true);
        }
        if (this.converter.getConfig().getAddReferenceDescriptions()) {
            this.descriptionMessage((Shape)member).ifPresent(refBuilder::description);
        }
        if (member.hasTrait(DefaultTrait.class) && !this.converter.getConfig().getDisableDefaultValues()) {
            Schema def = Schema.builder().defaultValue(((DefaultTrait)member.expectTrait(DefaultTrait.class)).toNode()).build();
            return Schema.builder().allOf(ListUtils.of((Object)refBuilder.build(), (Object)def)).build();
        }
        return refBuilder.build();
    }

    public Schema mapShape(MapShape shape) {
        JsonSchemaConfig.MapStrategy mapStrategy = this.converter.getConfig().getMapStrategy();
        switch (mapStrategy) {
            case PROPERTY_NAMES: {
                return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "object").propertyNames(this.createRef(shape.getKey())).additionalProperties(this.createRef(shape.getValue())));
            }
            case PATTERN_PROPERTIES: {
                String keyPattern = shape.getKey().getMemberTrait(this.model, PatternTrait.class).map(PatternTrait::getPattern).map(Pattern::pattern).orElse(".+");
                return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "object").putPatternProperty(keyPattern, this.createRef(shape.getValue())));
            }
        }
        throw new SmithyJsonSchemaException(String.format("Unsupported map strategy: %s", new Object[]{mapStrategy}));
    }

    public Schema byteShape(ByteShape shape) {
        return this.buildIntegerSchema((Shape)shape);
    }

    public Schema shortShape(ShortShape shape) {
        return this.buildIntegerSchema((Shape)shape);
    }

    public Schema integerShape(IntegerShape shape) {
        return this.buildIntegerSchema((Shape)shape);
    }

    public Schema longShape(LongShape shape) {
        return this.buildIntegerSchema((Shape)shape);
    }

    private Schema buildIntegerSchema(Shape shape) {
        String type = this.converter.getConfig().getUseIntegerType() ? "integer" : "number";
        return this.buildSchema(shape, this.createBuilder(shape, type));
    }

    public Schema floatShape(FloatShape shape) {
        return this.buildFloatSchema((Shape)shape);
    }

    public Schema doubleShape(DoubleShape shape) {
        return this.buildFloatSchema((Shape)shape);
    }

    private Schema buildFloatSchema(Shape shape) {
        Schema.Builder numberBuilder = this.createBuilder(shape, "number");
        if (!this.converter.getConfig().getSupportNonNumericFloats()) {
            return this.buildSchema(shape, numberBuilder);
        }
        Schema nonNumericValues = Schema.builder().type("string").enumValues(NON_NUMERIC_FLOAT_VALUES).build();
        Schema.Builder nonNumericNumberBuilder = this.createBuilder(shape, "number").type(null).oneOf(ListUtils.of((Object)numberBuilder.build(), (Object)nonNumericValues));
        return this.buildSchema(shape, nonNumericNumberBuilder);
    }

    public Schema bigIntegerShape(BigIntegerShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "number"));
    }

    public Schema bigDecimalShape(BigDecimalShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "number"));
    }

    public Schema stringShape(StringShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "string"));
    }

    public Schema structureShape(StructureShape shape) {
        return this.structuredShape((Shape)shape, shape.getAllMembers().values());
    }

    private Schema structuredShape(Shape container, Collection<MemberShape> memberShapes) {
        Schema.Builder builder = this.createBuilder(container, "object");
        ArrayList<String> required = new ArrayList<String>();
        for (MemberShape member : memberShapes) {
            String memberName = this.converter.toPropertyName(member);
            if (member.isRequired()) {
                required.add(memberName);
            }
            builder.putProperty(memberName, this.createRef(member));
        }
        builder.required(required);
        return this.buildSchema(container, builder);
    }

    public Schema unionShape(UnionShape shape) {
        JsonSchemaConfig.UnionStrategy unionStrategy = this.converter.getConfig().getUnionStrategy();
        switch (unionStrategy) {
            case OBJECT: {
                return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "object"));
            }
            case STRUCTURE: {
                return this.structuredShape((Shape)shape, shape.getAllMembers().values());
            }
            case ONE_OF: {
                ArrayList<Schema> schemas = new ArrayList<Schema>();
                for (MemberShape member : shape.getAllMembers().values()) {
                    String memberName = this.converter.toPropertyName(member);
                    schemas.add(Schema.builder().type("object").title(memberName).required(ListUtils.of((Object)memberName)).putProperty(memberName, this.createRef(member)).build());
                }
                return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "object").type(null).oneOf(schemas));
            }
        }
        throw new SmithyJsonSchemaException(String.format("Unsupported union strategy: %s", new Object[]{unionStrategy}));
    }

    public Schema timestampShape(TimestampShape shape) {
        return this.buildSchema((Shape)shape, this.createBuilder((Shape)shape, "string"));
    }

    public Schema memberShape(MemberShape memberShape) {
        Shape target = this.getTarget(memberShape);
        return this.buildSchema((Shape)memberShape, this.updateBuilder((Shape)memberShape, ((Schema)target.accept((ShapeVisitor)this)).toBuilder()));
    }

    private Shape getTarget(MemberShape member) {
        return (Shape)this.model.getShape(member.getTarget()).orElseThrow(() -> new SmithyJsonSchemaException("Unable to find the shape targeted by " + member));
    }

    private Schema.Builder createBuilder(Shape shape, String defaultType) {
        return this.updateBuilder(shape, Schema.builder().type(defaultType));
    }

    private Schema.Builder updateBuilder(Shape shape, Schema.Builder builder) {
        this.descriptionMessage(shape).ifPresent(builder::description);
        shape.getTrait(TitleTrait.class).map(StringTrait::getValue).ifPresent(builder::title);
        shape.getTrait(MediaTypeTrait.class).map(StringTrait::getValue).ifPresent(builder::contentMediaType);
        shape.getMemberTrait(this.model, PatternTrait.class).map(PatternTrait::getPattern).map(Pattern::pattern).ifPresent(builder::pattern);
        shape.getMemberTrait(this.model, RangeTrait.class).ifPresent(t -> {
            t.getMin().ifPresent(builder::minimum);
            t.getMax().ifPresent(builder::maximum);
        });
        shape.getMemberTrait(this.model, LengthTrait.class).ifPresent(t -> {
            Shape targetShape;
            block5: {
                block4: {
                    targetShape = shape.asMemberShape().flatMap(target -> this.model.getShape(target.getTarget())).orElse(shape);
                    if (targetShape.isListShape()) break block4;
                    if (!targetShape.isSetShape()) break block5;
                }
                t.getMin().map(Long::intValue).ifPresent(builder::minItems);
                t.getMax().map(Long::intValue).ifPresent(builder::maxItems);
                return;
            }
            if (targetShape.isMapShape()) {
                t.getMin().map(Long::intValue).ifPresent(builder::minProperties);
                t.getMax().map(Long::intValue).ifPresent(builder::maxProperties);
                return;
            }
            t.getMin().ifPresent(builder::minLength);
            t.getMax().ifPresent(builder::maxLength);
        });
        if (shape.hasTrait(UniqueItemsTrait.class)) {
            builder.uniqueItems(true);
        }
        shape.getTrait(EnumTrait.class).map(EnumTrait::getEnumDefinitionValues).ifPresent(builder::enumValues);
        if (shape.isIntEnumShape() && !this.converter.getConfig().getDisableIntEnums()) {
            builder.intEnumValues(((IntEnumShape)shape.asIntEnumShape().get()).getEnumValues().values());
        }
        if (shape.hasTrait(DefaultTrait.class) && !this.converter.getConfig().getDisableDefaultValues()) {
            builder.defaultValue(((DefaultTrait)shape.expectTrait(DefaultTrait.class)).toNode());
        }
        if (shape.hasTrait(DeprecatedTrait.class) && this.getJsonSchemaVersion() != JsonSchemaVersion.DRAFT07) {
            builder.deprecated(true);
        }
        return builder;
    }

    private Optional<String> descriptionMessage(Shape shape) {
        StringBuilder builder = new StringBuilder();
        shape.getTrait(DocumentationTrait.class).ifPresent(trait -> builder.append(trait.getValue()));
        shape.getTrait(DeprecatedTrait.class).ifPresent(trait -> builder.append("\n").append(trait.getDeprecatedDescription(shape.getType())));
        String description = builder.toString().trim();
        return description.isEmpty() ? Optional.empty() : Optional.of(description);
    }

    private Schema buildSchema(Shape shape, Schema.Builder builder) {
        JsonSchemaMapperContext context = new JsonSchemaMapperContext(this.model, shape, this.converter.getConfig());
        for (JsonSchemaMapper mapper : this.mappers) {
            builder = mapper.updateSchema(context, builder);
        }
        return builder.build();
    }

    private JsonSchemaVersion getJsonSchemaVersion() {
        return this.converter.getConfig().getJsonSchemaVersion();
    }
}

