/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jsonschema;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import software.amazon.smithy.jsonschema.DisableMapper;
import software.amazon.smithy.jsonschema.JsonSchemaMapper;
import software.amazon.smithy.jsonschema.JsonSchemaShapeVisitor;
import software.amazon.smithy.jsonschema.PropertyNamingStrategy;
import software.amazon.smithy.jsonschema.RefStrategy;
import software.amazon.smithy.jsonschema.Schema;
import software.amazon.smithy.jsonschema.SchemaDocument;
import software.amazon.smithy.jsonschema.TimestampMapper;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.loader.Prelude;
import software.amazon.smithy.model.neighbor.Walker;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.node.ObjectNode;
import software.amazon.smithy.model.shapes.ServiceShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.shapes.ShapeIndex;
import software.amazon.smithy.model.shapes.ShapeVisitor;
import software.amazon.smithy.model.shapes.ToShapeId;
import software.amazon.smithy.model.traits.EffectiveTraitQuery;
import software.amazon.smithy.model.traits.PrivateTrait;
import software.amazon.smithy.utils.FunctionalUtils;
import software.amazon.smithy.utils.Pair;

public final class JsonSchemaConverter {
    private static final RefStrategy DEFAULT_REF_STRATEGY = RefStrategy.createDefaultStrategy();
    private final List<JsonSchemaMapper> mappers = new ArrayList<JsonSchemaMapper>();
    private PropertyNamingStrategy propertyNamingStrategy;
    private ObjectNode config = Node.objectNode();
    private RefStrategy refStrategy;
    private Predicate<Shape> shapePredicate = shape -> true;
    private boolean softRefStrategy = false;

    private JsonSchemaConverter() {
        this.mappers.add(new DisableMapper());
        this.mappers.add(new TimestampMapper());
    }

    public static JsonSchemaConverter create() {
        return new JsonSchemaConverter();
    }

    public JsonSchemaConverter copy() {
        JsonSchemaConverter copy = JsonSchemaConverter.create();
        copy.config = this.config;
        copy.mappers.addAll(this.mappers);
        copy.propertyNamingStrategy = this.propertyNamingStrategy;
        copy.refStrategy = this.refStrategy;
        copy.shapePredicate = this.shapePredicate;
        return copy;
    }

    public JsonSchemaConverter shapePredicate(Predicate<Shape> shapePredicate) {
        this.shapePredicate = shapePredicate;
        return this;
    }

    public JsonSchemaConverter config(ObjectNode config) {
        this.config = config;
        return this;
    }

    public ObjectNode getConfig() {
        return this.config;
    }

    public JsonSchemaConverter propertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this.propertyNamingStrategy = propertyNamingStrategy;
        return this;
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        if (this.propertyNamingStrategy == null) {
            this.propertyNamingStrategy = PropertyNamingStrategy.createDefaultStrategy();
        }
        return this.propertyNamingStrategy;
    }

    public JsonSchemaConverter refStrategy(RefStrategy refStrategy) {
        this.softRefStrategy = false;
        this.refStrategy = refStrategy;
        return this;
    }

    public RefStrategy getRefStrategy() {
        return this.refStrategy != null ? this.refStrategy : DEFAULT_REF_STRATEGY;
    }

    public JsonSchemaConverter addMapper(JsonSchemaMapper jsonSchemaMapper) {
        this.mappers.add(jsonSchemaMapper);
        return this;
    }

    @Deprecated
    public SchemaDocument convert(ShapeIndex shapeIndex) {
        return this.doConversion(shapeIndex, null);
    }

    public SchemaDocument convert(Model model) {
        return this.convert(model.getShapeIndex());
    }

    public SchemaDocument convert(ShapeIndex shapeIndex, Shape shape) {
        return this.doConversion(shapeIndex, shape);
    }

    public SchemaDocument convert(Model model, Shape shape) {
        return this.convert(model.getShapeIndex(), shape);
    }

    private SchemaDocument doConversion(ShapeIndex shapeIndex, Shape rootShape) {
        if (this.softRefStrategy || this.refStrategy == null) {
            this.softRefStrategy = true;
            this.refStrategy = RefStrategy.createDefaultDeconflictingStrategy(shapeIndex, this.getConfig());
        }
        this.mappers.sort(Comparator.comparing(JsonSchemaMapper::getOrder));
        SchemaDocument.Builder builder = SchemaDocument.builder();
        JsonSchemaShapeVisitor visitor = new JsonSchemaShapeVisitor(shapeIndex, this.getConfig(), this.getRefStrategy(), this.getPropertyNamingStrategy(), this.mappers);
        if (rootShape != null && !(rootShape instanceof ServiceShape)) {
            builder.rootSchema((Schema)rootShape.accept((ShapeVisitor)visitor));
        }
        this.addExtensions(builder);
        Predicate<Shape> predicate = this.composePredicate(shapeIndex, rootShape);
        shapeIndex.shapes().filter(predicate).filter(shape -> this.memberDefinitionPredicate(shapeIndex, (Shape)shape, predicate)).map(shape -> Pair.of((Object)this.getRefStrategy().toPointer(shape.getId(), this.getConfig()), (Object)((Schema)shape.accept((ShapeVisitor)visitor)))).forEach(pair -> builder.putDefinition((String)pair.getLeft(), (Schema)pair.getRight()));
        return builder.build();
    }

    private Predicate<Shape> composePredicate(ShapeIndex shapeIndex, Shape rootShape) {
        Predicate<Shape> predicate = shape -> rootShape == null || !shape.getId().equals((Object)rootShape.getId());
        predicate = predicate.and(FunctionalUtils.not(Prelude::isPreludeShape));
        predicate = predicate.and(FunctionalUtils.not(this::isUnsupportedShapeType));
        predicate = predicate.and(shape -> !this.isExcludedPrivateShape(shapeIndex, (Shape)shape));
        predicate = predicate.and(this.shapePredicate);
        if (rootShape != null) {
            Walker walker = new Walker(shapeIndex);
            Set connected = walker.walkShapes(rootShape);
            predicate = predicate.and(connected::contains);
        }
        return predicate;
    }

    private boolean isUnsupportedShapeType(Shape shape) {
        return shape.isServiceShape() || shape.isResourceShape() || shape.isOperationShape();
    }

    private boolean memberDefinitionPredicate(ShapeIndex shapeIndex, Shape shape, Predicate<Shape> predicate) {
        if (!shape.isMemberShape()) {
            return true;
        }
        if (this.getConfig().getBooleanMemberOrDefault("inlineMembers")) {
            return false;
        }
        return shape.asMemberShape().flatMap(member -> shapeIndex.getShape(member.getContainer())).filter(parent -> parent.equals((Object)shape) || predicate.test(shape)).isPresent();
    }

    private boolean isExcludedPrivateShape(ShapeIndex shapeIndex, Shape shape) {
        if (this.getConfig().getBooleanMemberOrDefault("includePrivateShapes")) {
            return false;
        }
        return EffectiveTraitQuery.builder().shapeIndex(shapeIndex).traitClass(PrivateTrait.class).inheritFromContainer(true).build().isTraitApplied((ToShapeId)shape);
    }

    private void addExtensions(SchemaDocument.Builder builder) {
        this.getConfig().getObjectMember("schemaDocumentExtensions").ifPresent(builder::extensions);
    }
}

