/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.jmespath.ast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import software.amazon.smithy.jmespath.ExpressionVisitor;
import software.amazon.smithy.jmespath.JmespathException;
import software.amazon.smithy.jmespath.JmespathExpression;
import software.amazon.smithy.jmespath.RuntimeType;

public final class LiteralExpression
extends JmespathExpression {
    public static final LiteralExpression ANY = new LiteralExpression(new Object());
    public static final LiteralExpression ARRAY = new LiteralExpression(new ArrayList());
    public static final LiteralExpression OBJECT = new LiteralExpression(new HashMap());
    public static final LiteralExpression BOOLEAN = new LiteralExpression(false);
    public static final LiteralExpression STRING = new LiteralExpression("");
    public static final LiteralExpression NUMBER = new LiteralExpression(0);
    public static final LiteralExpression EXPREF = new LiteralExpression(o -> null);
    public static final LiteralExpression NULL = new LiteralExpression(null);
    private final Object value;

    public LiteralExpression(Object value) {
        this(value, 1, 1);
    }

    public LiteralExpression(Object value, int line, int column) {
        super(line, column);
        this.value = value instanceof LiteralExpression ? ((LiteralExpression)value).getValue() : value;
    }

    public static LiteralExpression from(Object value) {
        if (value instanceof LiteralExpression) {
            return (LiteralExpression)value;
        }
        return new LiteralExpression(value);
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitLiteral(this);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LiteralExpression)) {
            return false;
        }
        LiteralExpression other = (LiteralExpression)o;
        if (this.value instanceof Number && other.getValue() instanceof Number) {
            return ((Number)this.value).doubleValue() == ((Number)other.getValue()).doubleValue();
        }
        return Objects.equals(this.value, ((LiteralExpression)o).value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "LiteralExpression{value=" + this.value + '}';
    }

    public RuntimeType getType() {
        if (this.isArrayValue()) {
            return RuntimeType.ARRAY;
        }
        if (this.isObjectValue()) {
            return RuntimeType.OBJECT;
        }
        if (this.isStringValue()) {
            return RuntimeType.STRING;
        }
        if (this.isBooleanValue()) {
            return RuntimeType.BOOLEAN;
        }
        if (this.isNumberValue()) {
            return RuntimeType.NUMBER;
        }
        if (this.isNullValue()) {
            return RuntimeType.NULL;
        }
        if (this == EXPREF) {
            return RuntimeType.EXPRESSION;
        }
        return RuntimeType.ANY;
    }

    public LiteralExpression getObjectField(String name) {
        Map<String, Object> values = this.expectObjectValue();
        return values.containsKey(name) ? new LiteralExpression(values.get(name)) : new LiteralExpression(null);
    }

    public boolean hasObjectField(String name) {
        return this.expectObjectValue().containsKey(name);
    }

    public LiteralExpression getArrayIndex(int index) {
        List<Object> values = this.expectArrayValue();
        if (index < 0) {
            index = values.size() + index;
        }
        return index >= 0 && values.size() > index ? new LiteralExpression(values.get(index)) : new LiteralExpression(null);
    }

    public boolean isStringValue() {
        return this.value instanceof String;
    }

    public boolean isNumberValue() {
        return this.value instanceof Number;
    }

    public boolean isBooleanValue() {
        return this.value instanceof Boolean;
    }

    public boolean isArrayValue() {
        return this.value instanceof List;
    }

    public boolean isObjectValue() {
        return this.value instanceof Map;
    }

    public boolean isNullValue() {
        return this.value == null;
    }

    public String expectStringValue() {
        if (this.value instanceof String) {
            return (String)this.value;
        }
        throw new JmespathException("Expected a string literal, but found " + this.value.getClass());
    }

    public Number expectNumberValue() {
        if (this.value instanceof Number) {
            return (Number)this.value;
        }
        throw new JmespathException("Expected a number literal, but found " + this.value.getClass());
    }

    public boolean expectBooleanValue() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        throw new JmespathException("Expected a boolean literal, but found " + this.value.getClass());
    }

    public List<Object> expectArrayValue() {
        try {
            return (List)this.value;
        }
        catch (ClassCastException e) {
            throw new JmespathException("Expected an array literal, but found " + this.value.getClass());
        }
    }

    public Map<String, Object> expectObjectValue() {
        try {
            return (Map)this.value;
        }
        catch (ClassCastException e) {
            throw new JmespathException("Expected a map literal, but found " + this.value.getClass());
        }
    }

    public boolean isTruthy() {
        switch (this.getType()) {
            case ANY: 
            case NUMBER: 
            case EXPRESSION: {
                return true;
            }
            case STRING: {
                return !this.expectStringValue().isEmpty();
            }
            case ARRAY: {
                return !this.expectArrayValue().isEmpty();
            }
            case OBJECT: {
                return !this.expectObjectValue().isEmpty();
            }
            case BOOLEAN: {
                return this.expectBooleanValue();
            }
        }
        return false;
    }
}

