/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import software.amazon.smithy.diff.ChangedMetadata;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.model.Model;
import software.amazon.smithy.model.node.Node;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.utils.BuilderRef;
import software.amazon.smithy.utils.Pair;
import software.amazon.smithy.utils.SmithyBuilder;
import software.amazon.smithy.utils.ToSmithyBuilder;

public final class Differences
implements ToSmithyBuilder<Differences> {
    private final Model oldModel;
    private final Model newModel;
    private final List<Shape> addedShapes;
    private final List<Shape> removedShapes;
    private final List<ChangedShape<Shape>> changedShapes;
    private final List<Pair<String, Node>> addedMetadata;
    private final List<Pair<String, Node>> removedMetadata;
    private final List<ChangedMetadata> changedMetadata;

    private Differences(Builder builder) {
        this.oldModel = (Model)SmithyBuilder.requiredState((String)"oldModel", (Object)builder.oldModel);
        this.newModel = (Model)SmithyBuilder.requiredState((String)"newModel", (Object)builder.newModel);
        this.addedShapes = (List)builder.addedShapes.copy();
        this.removedShapes = (List)builder.removedShapes.copy();
        this.changedShapes = (List)builder.changedShapes.copy();
        this.addedMetadata = (List)builder.addedMetadata.copy();
        this.removedMetadata = (List)builder.removedMetadata.copy();
        this.changedMetadata = (List)builder.changedMetadata.copy();
    }

    public static Differences detect(Model oldModel, Model newModel) {
        return Differences.builder().oldModel(oldModel).newModel(newModel).detectShapeChanges().detectMetadataChanges().build();
    }

    public Model getOldModel() {
        return this.oldModel;
    }

    public Model getNewModel() {
        return this.newModel;
    }

    public Stream<Shape> addedShapes() {
        return this.addedShapes.stream();
    }

    public <T extends Shape> Stream<T> addedShapes(Class<T> shapeType) {
        return this.addedShapes().filter(shapeType::isInstance).map(shapeType::cast);
    }

    public Stream<Pair<String, Node>> addedMetadata() {
        return this.newModel.getMetadata().entrySet().stream().filter(entry -> !this.oldModel.getMetadata().containsKey(entry.getKey())).map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((Node)entry.getValue())));
    }

    public Stream<Shape> removedShapes() {
        return this.removedShapes.stream();
    }

    public <T extends Shape> Stream<T> removedShapes(Class<T> shapeType) {
        return this.removedShapes().filter(shapeType::isInstance).map(shapeType::cast);
    }

    public Stream<Pair<String, Node>> removedMetadata() {
        return this.removedMetadata.stream();
    }

    public Stream<ChangedShape<Shape>> changedShapes() {
        return this.changedShapes.stream();
    }

    public <T extends Shape> Stream<ChangedShape<T>> changedShapes(Class<T> type) {
        return this.changedShapes().filter(change -> type.isInstance(change.getOldShape()) && type.isInstance(change.getNewShape())).map(change -> change);
    }

    public Stream<ChangedMetadata> changedMetadata() {
        return this.changedMetadata.stream();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Differences)) {
            return false;
        }
        Differences that = (Differences)o;
        return this.getOldModel().equals((Object)that.getOldModel()) && this.getNewModel().equals((Object)that.getNewModel());
    }

    public int hashCode() {
        return Objects.hash(this.getOldModel(), this.getNewModel());
    }

    public static Builder builder() {
        return new Builder();
    }

    public SmithyBuilder<Differences> toBuilder() {
        return Differences.builder().oldModel(this.oldModel).newModel(this.newModel).addedShapes(this.addedShapes).removedShapes(this.removedShapes).changedShapes(this.changedShapes).addedMetadata(this.addedMetadata).removedMetadata(this.removedMetadata).changedMetadata(this.changedMetadata);
    }

    public static final class Builder
    implements SmithyBuilder<Differences> {
        private Model oldModel;
        private Model newModel;
        private final BuilderRef<List<Shape>> addedShapes = BuilderRef.forList();
        private final BuilderRef<List<Shape>> removedShapes = BuilderRef.forList();
        private final BuilderRef<List<ChangedShape<Shape>>> changedShapes = BuilderRef.forList();
        private final BuilderRef<List<Pair<String, Node>>> addedMetadata = BuilderRef.forList();
        private final BuilderRef<List<Pair<String, Node>>> removedMetadata = BuilderRef.forList();
        private final BuilderRef<List<ChangedMetadata>> changedMetadata = BuilderRef.forList();

        public Differences build() {
            return new Differences(this);
        }

        public Builder oldModel(Model oldModel) {
            this.oldModel = oldModel;
            return this;
        }

        public Builder newModel(Model newModel) {
            this.newModel = newModel;
            return this;
        }

        public Builder addedShapes(Collection<Shape> addedShapes) {
            this.addedShapes.clear();
            ((List)this.addedShapes.get()).addAll(addedShapes);
            return this;
        }

        public Builder removedShapes(Collection<Shape> removedShapes) {
            this.removedShapes.clear();
            ((List)this.removedShapes.get()).addAll(removedShapes);
            return this;
        }

        public Builder changedShapes(Collection<ChangedShape<Shape>> changedShapes) {
            this.changedShapes.clear();
            ((List)this.changedShapes.get()).addAll(changedShapes);
            return this;
        }

        public Builder changedShape(ChangedShape<Shape> changedShape) {
            ((List)this.changedShapes.get()).add(changedShape);
            return this;
        }

        public Builder addedMetadata(Collection<Pair<String, Node>> addedMetadata) {
            this.addedMetadata.clear();
            ((List)this.addedMetadata.get()).addAll(addedMetadata);
            return this;
        }

        public Builder removedMetadata(Collection<Pair<String, Node>> removedMetadata) {
            this.removedMetadata.clear();
            ((List)this.removedMetadata.get()).addAll(removedMetadata);
            return this;
        }

        public Builder changedMetadata(Collection<ChangedMetadata> changedMetadata) {
            this.changedMetadata.clear();
            ((List)this.changedMetadata.get()).addAll(changedMetadata);
            return this;
        }

        public Builder detectShapeChanges() {
            this.addedShapes.clear();
            this.removedShapes.clear();
            this.changedShapes.clear();
            for (Shape oldShape : this.oldModel.toSet()) {
                Optional newShape = this.newModel.getShape(oldShape.getId());
                if (newShape.isPresent()) {
                    if (oldShape.equals(newShape.get())) continue;
                    ((List)this.changedShapes.get()).add(new ChangedShape<Shape>(oldShape, (Shape)newShape.get()));
                    continue;
                }
                ((List)this.removedShapes.get()).add(oldShape);
            }
            for (Shape newShape : this.newModel.toSet()) {
                if (this.oldModel.getShape(newShape.getId()).isPresent()) continue;
                ((List)this.addedShapes.get()).add(newShape);
            }
            return this;
        }

        public Builder detectMetadataChanges() {
            this.addedMetadata.clear();
            this.removedMetadata.clear();
            this.changedMetadata.clear();
            for (Map.Entry entry : this.oldModel.getMetadata().entrySet()) {
                String k = (String)entry.getKey();
                Node v = (Node)entry.getValue();
                if (this.newModel.getMetadata().containsKey(k)) {
                    if (((Node)this.newModel.getMetadata().get(k)).equals(v)) continue;
                    ((List)this.changedMetadata.get()).add(new ChangedMetadata(k, v, (Node)this.newModel.getMetadata().get(k)));
                    continue;
                }
                ((List)this.removedMetadata.get()).add(Pair.of((Object)k, (Object)v));
            }
            for (Map.Entry entry : this.newModel.getMetadata().entrySet()) {
                if (this.oldModel.getMetadata().containsKey(entry.getKey())) continue;
                ((List)this.addedMetadata.get()).add(Pair.of((Object)((String)entry.getKey()), (Object)((Node)entry.getValue())));
            }
            return this;
        }
    }
}

