/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.shapes.MemberShape;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.DefaultTrait;
import software.amazon.smithy.model.traits.RequiredTrait;
import software.amazon.smithy.model.validation.ValidationEvent;

public class AddedDefaultTrait
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        return differences.changedShapes(MemberShape.class).map(change -> {
            MemberShape oldShape = (MemberShape)change.getOldShape();
            MemberShape newShape = (MemberShape)change.getNewShape();
            if (newShape.hasTrait(DefaultTrait.class) && !oldShape.hasTrait(DefaultTrait.class) && !oldShape.hasTrait(RequiredTrait.class)) {
                return this.error((Shape)newShape, "Added the @default trait. This is only backward compatible if the @default trait is used to replace the @required trait.");
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

