/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.EnumDefinition;
import software.amazon.smithy.model.traits.EnumTrait;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.OptionalUtils;
import software.amazon.smithy.utils.Pair;

public final class ChangedEnumTrait
extends AbstractDiffEvaluator {
    @Override
    public List<ValidationEvent> evaluate(Differences differences) {
        return differences.changedShapes().flatMap(change -> OptionalUtils.stream(change.getChangedTrait(EnumTrait.class)).map(p -> Pair.of((Object)change, (Object)p))).flatMap(pair -> this.validateEnum((ChangedShape)pair.getLeft(), (Pair<EnumTrait, EnumTrait>)((Pair)pair.getRight())).stream()).collect(Collectors.toList());
    }

    private List<ValidationEvent> validateEnum(ChangedShape<Shape> change, Pair<EnumTrait, EnumTrait> trait) {
        EnumTrait oldTrait = (EnumTrait)trait.getLeft();
        EnumTrait newTrait = (EnumTrait)trait.getRight();
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        int oldEndPosition = oldTrait.getValues().size() - 1;
        for (EnumDefinition definition : oldTrait.getValues()) {
            Optional<EnumDefinition> maybeNewValue = newTrait.getValues().stream().filter(d -> d.getValue().equals(definition.getValue())).findFirst();
            if (!maybeNewValue.isPresent()) {
                events.add(this.error(change.getNewShape(), String.format("Enum value `%s` was removed", definition.getValue())));
                --oldEndPosition;
                continue;
            }
            EnumDefinition newValue = maybeNewValue.get();
            if (newValue.getName().equals(definition.getName())) continue;
            events.add(this.error(change.getNewShape(), String.format("Enum `name` changed from `%s` to `%s` for the `%s` value", definition.getName().orElse(null), newValue.getName().orElse(null), definition.getValue())));
        }
        int newPosition = 0;
        for (EnumDefinition definition : newTrait.getValues()) {
            if (!oldTrait.getEnumDefinitionValues().contains(definition.getValue())) {
                if (newPosition <= oldEndPosition) {
                    events.add(this.error(change.getNewShape(), String.format("Enum value `%s` was inserted before the end of the list of existing values. This can cause compatibility issues when ordinal values are used for iteration, serialization, etc.", definition.getValue())));
                } else {
                    events.add(this.note(change.getNewShape(), String.format("Enum value `%s` was appended", definition.getValue())));
                }
            }
            ++newPosition;
        }
        return events;
    }
}

