/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.smithy.diff.evaluators;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.smithy.diff.ChangedShape;
import software.amazon.smithy.diff.Differences;
import software.amazon.smithy.diff.evaluators.AbstractDiffEvaluator;
import software.amazon.smithy.model.shapes.Shape;
import software.amazon.smithy.model.traits.Trait;
import software.amazon.smithy.model.validation.ValidationEvent;
import software.amazon.smithy.utils.Pair;

abstract class AbstractLengthAndRangeValidator<T extends Trait>
extends AbstractDiffEvaluator {
    AbstractLengthAndRangeValidator() {
    }

    @Override
    public final List<ValidationEvent> evaluate(Differences differences) {
        return differences.changedShapes().flatMap(change -> {
            Pair pair = change.getChangedTrait(this.getTraitType()).orElse(null);
            return pair == null ? Stream.empty() : this.validateTrait((ChangedShape<Shape>)change, (Pair<T, T>)pair).stream();
        }).collect(Collectors.toList());
    }

    abstract Class<T> getTraitType();

    abstract Optional<BigDecimal> getMin(T var1);

    abstract Optional<BigDecimal> getMax(T var1);

    private List<ValidationEvent> validateTrait(ChangedShape<Shape> change, Pair<T, T> changedTrait) {
        ArrayList<ValidationEvent> events = new ArrayList<ValidationEvent>();
        Trait oldTrait = (Trait)changedTrait.getLeft();
        Trait newTrait = (Trait)changedTrait.getRight();
        BigDecimal oldMin = this.getMin(oldTrait).orElse(BigDecimal.ZERO);
        BigDecimal newMin = this.getMin(newTrait).orElse(BigDecimal.ZERO);
        BigDecimal oldMax = this.getMax(oldTrait).orElse(null);
        BigDecimal newMax = this.getMax(newTrait).orElse(null);
        if (newMin.compareTo(oldMin) > 0) {
            events.add(this.error(change.getNewShape(), String.format("%s trait value `min` was made more restrictive by raising from %s to %s", newTrait.toShapeId(), oldMin, newMin)));
        }
        if (newMax != null && (oldMax == null || oldMax.compareTo(newMax) > 0)) {
            events.add(this.error(change.getNewShape(), String.format("%s trait value `max` was made more restrictive by lowering from %s to %s", newTrait.toShapeId(), oldMax, newMax)));
        }
        return events;
    }
}

